#!/bin/bash
set -ex

IDIR=$(pwd)
TEMPORAL_HOME=$IDIR/temporal_home
mkdir -p $TEMPORAL_HOME/config

BIND_ON_IP='::' \
TEMPORAL_TLS_CA_CERT=$IDIR/temporal-certs/all-root-ca.pem \
PROMETHEUS_ENDPOINT=localhost:31337 \
./dockerize -template ./config_template.yaml:$TEMPORAL_HOME/config/docker.yaml

cp ./server $TEMPORAL_HOME/server
cd $TEMPORAL_HOME
exec ./server --root $TEMPORAL_HOME --env docker start "$@"
