package main

import (
	"context"
	"fmt"
	"time"

	"a.yandex-team.ru/library/go/yandex/blackbox"
	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
	"github.com/karlseguin/ccache/v2"
)

func getLoginByOauthToken(ctx context.Context, client *httpbb.Client, oauthToken, userIP string) (string, error) {
	if resp, err := client.OAuth(ctx, blackbox.OAuthRequest{
		OAuthToken: oauthToken,
		UserIP:     userIP,
	}); err == nil {
		return resp.User.Login, nil
	} else {
		return "", fmt.Errorf("cannot authorize user (IP: %s): %w", userIP, err)
	}
}

func getLoginByOauthTokenWithCache(ctx context.Context, cache *ccache.Cache, client *httpbb.Client, oauthToken, userIP string) (string, bool, error) {
	cacheKey := oauthToken + "/" + userIP
	item := cache.Get(cacheKey)
	if item != nil && !item.Expired() {
		login := item.Value().(string)
		return login, true, nil
	}
	login, err := getLoginByOauthToken(ctx, client, oauthToken, userIP)
	if err != nil {
		return "", false, err
	}
	cache.Set(cacheKey, login, time.Minute*30)
	return login, false, nil
}
