package main

import (
	"go.temporal.io/server/common/authorization"
	"go.temporal.io/server/common/config"
)

type swatClaimMapper struct{}

func NewSwatClaimMapper(_ *config.Config) authorization.ClaimMapper {
	return &swatClaimMapper{}
}

func (c swatClaimMapper) GetClaims(authInfo *authorization.AuthInfo) (*authorization.Claims, error) {
	if authInfo.TLSSubject.CommonName == "swat-temporal" {
		claims := authorization.Claims{
			Subject: "swat-temporal-web",
			System:  authorization.RoleAdmin,
		}
		return &claims, nil
	}
	if authInfo.AuthToken == "" {
		return nil, nil
	}
	return &authorization.Claims{
		Subject:    "anonymous",
		System:     authorization.RoleUndefined,
		Extensions: authInfo.AuthToken,
	}, nil
}
