package awacs

import (
	awacspb "a.yandex-team.ru/infra/awacs/proto"
	awacsactivities "a.yandex-team.ru/infra/temporal/activities/awacs"
	"fmt"
	"go.temporal.io/sdk/temporal"
	"go.temporal.io/sdk/workflow"
	"time"
)

func DummyWorkflow(ctx workflow.Context, namespaceID string) error {
	commonCtx := workflow.WithActivityOptions(ctx, workflow.ActivityOptions{
		StartToCloseTimeout: time.Minute * 30,
		HeartbeatTimeout:    time.Minute * 2,
		RetryPolicy: &temporal.RetryPolicy{
			InitialInterval:        time.Second * 30,
			BackoffCoefficient:     1.1,
			MaximumInterval:        time.Minute * 5,
			MaximumAttempts:        30,
			NonRetryableErrorTypes: []string{"PermanentError"},
		},
	})

	var a *awacsactivities.Activities

	var balancers []*awacspb.Balancer
	err := workflow.ExecuteActivity(commonCtx, a.ListBalancersByNamespaceID, namespaceID).Get(ctx, &balancers)
	if err != nil {
		return err
	}
	fmt.Println(balancers)
	workflow.GetLogger(ctx).Warn("DONE")
	return nil
}
