// +build migrate_backend

package awacs

import (
	awacsactivities "a.yandex-team.ru/infra/temporal/activities/awacs"
	temporalclient "a.yandex-team.ru/infra/temporal/swat/client"
	"fmt"
	"github.com/stretchr/testify/suite"
	"go.temporal.io/sdk/testsuite"
	"log"
	"os"
	"testing"
	"time"
)

const (
	AwacsTokenEnvVarName  = "AWACS_TOKEN"
	AwacsApiUrlEnvVarName = "AWACS_API_URL"
	NamespaceId           = "anttsov-test-balancer-ns"
)

type UnitTestSuite struct {
	suite.Suite
	testsuite.WorkflowTestSuite

	env *testsuite.TestWorkflowEnvironment
}

func (s *UnitTestSuite) SetupTest() {
	awacsApiUrl := getEnvVar(AwacsApiUrlEnvVarName)
	awacsOauthToken := getEnvVar(AwacsTokenEnvVarName)
	a := awacsactivities.NewActivities(awacsApiUrl, awacsOauthToken, nil)
	s.env = s.NewTestWorkflowEnvironment().
		SetDataConverter(temporalclient.GetDefaultSwatDataConverter())
	s.env.RegisterActivity(a)
}

func (s *UnitTestSuite) AfterTest(suiteName, testName string) {
	s.env.AssertExpectations(s.T())
}

func (s *UnitTestSuite) Test_MigrateBackendWorkflow_Success() {
	s.env.SetWorkflowRunTimeout(10 * time.Minute)
	s.env.SetTestTimeout(10 * time.Minute)
	s.env.ExecuteWorkflow(MigrateBackendToSDWorkflow, NamespaceId)

	s.True(s.env.IsWorkflowCompleted())
	s.NoError(s.env.GetWorkflowError())
}

func TestUnitTestSuite(t *testing.T) {
	suite.Run(t, new(UnitTestSuite))
}

func getEnvVar(envVar string) string {
	val := os.Getenv(envVar)
	if val == "" {
		log.Fatalln(fmt.Sprintf("env var %s is required", envVar))
	}
	return val
}
