package awacs

import (
	awacsactivities "a.yandex-team.ru/infra/temporal/activities/awacs"
	"fmt"
	"os"
	"time"

	"go.temporal.io/sdk/workflow"
)

func ProcessNamespaceWorkflow(ctx workflow.Context, namespaceID string) error {
	wCtx := workflow.WithActivityOptions(ctx, workflow.ActivityOptions{
		StartToCloseTimeout: time.Hour * 24 * 365 * 100,
		HeartbeatTimeout:    awacsactivities.WatchHeartbeatTimeout,
	})

	var a *awacsactivities.WatchingActivities
	var threadErr error
	closed := false
	var stuckL7ChildWf workflow.ChildWorkflowFuture
	var stuckL3ChildWf workflow.ChildWorkflowFuture

	processStuckBalancers := func(ctx workflow.Context) {
		currStuckBalancerIDs := make([]string, 0)
		for {
			var stuckBalancerIDs []string
			err := workflow.ExecuteActivity(wCtx, a.WaitUntilStuckBalancerIDsChange, namespaceID, currStuckBalancerIDs).Get(ctx, &stuckBalancerIDs)
			if err != nil {
				threadErr = err
				return
			}
			currStuckBalancerIDs = stuckBalancerIDs
			stuckL7ChildWf, err = CreateOrUpdateStuckProblem(
				ctx,
				namespaceID,
				"stuckl7",
				fmt.Sprintf("process-stuck-balancers(%s)", namespaceID),
				stuckBalancerIDs,
				stuckL7ChildWf,
			)
			if err != nil {
				threadErr = err
				return
			}
		}
	}

	processStuckL3Balancers := func(ctx workflow.Context) {
		currStuckL3BalancerIDs := make([]string, 0)
		for {
			var stuckL3BalancerIDs []string
			err := workflow.ExecuteActivity(wCtx, a.WaitUntilStuckL3BalancerIDsChange, namespaceID, currStuckL3BalancerIDs).Get(ctx, &stuckL3BalancerIDs)
			if err != nil {
				threadErr = err
				return
			}
			currStuckL3BalancerIDs = stuckL3BalancerIDs
			stuckL3ChildWf, err = CreateOrUpdateStuckProblem(ctx,
				namespaceID,
				"stuckl3",
				fmt.Sprintf("process-stuck-l3-balancers(%s)", namespaceID),
				stuckL3BalancerIDs,
				stuckL3ChildWf,
			)
			if err != nil {
				threadErr = err
				return
			}
		}
	}

	waitUntilNamespaceRemoved := func(ctx workflow.Context) {
		for {
			var removed bool
			err := workflow.ExecuteActivity(wCtx, a.WaitUntilNamespaceRemoved, namespaceID).Get(ctx, &removed)
			if err != nil {
				threadErr = err
				return
			}
			if removed {
				if stuckL7ChildWf != nil {
					childCtx := workflow.WithWorkflowNamespace(ctx, os.Getenv(StartrekerNamespaceIDEnvVar))
					stuckL7ChildWf.SignalChildWorkflow(childCtx, "CloseProblem", nil)
				}
				if stuckL3ChildWf != nil {
					childCtx := workflow.WithWorkflowNamespace(ctx, os.Getenv(StartrekerNamespaceIDEnvVar))
					stuckL3ChildWf.SignalChildWorkflow(childCtx, "CloseProblem", nil)
				}
				closed = true
				return
			}
		}
	}

	workflow.Go(ctx, processStuckBalancers)
	workflow.Go(ctx, processStuckL3Balancers)
	workflow.Go(ctx, waitUntilNamespaceRemoved)

	err := workflow.Await(ctx, func() bool {
		return closed || threadErr != nil
	})
	if err != nil {
		return err
	}
	return threadErr
}
