package servicepodalerts

import (
	"bytes"
	"testing"
	"time"

	pb "a.yandex-team.ru/infra/nanny/go/proto/nanny_repo"
	"a.yandex-team.ru/infra/temporal/activities/nanny/pods"
	"github.com/stretchr/testify/require"
	"github.com/stretchr/testify/suite"
)

type GeneralTemplateTestSuite struct {
	suite.Suite
}

func (suite *GeneralTemplateTestSuite) TestGeneralTemplateInit() {
	states := []*State{
		{
			Timestamp: time.Now(),
			ServiceState: &ServiceState{
				SnapshotStatus: pb.SnapshotStatus_ACTIVE,
				ServiceStatus:  "ACTIVE",
			},
			PodStates: map[string]*PodState{
				"some-pod-hostname": {
					State: "HOOK_SEMI_FAILED",
					Eviction: &pods.Eviction{
						LastUpdated: time.Now(),
					},
				},
			},
		},
	}
	tmpl := &GeneralTemplateController{
		Decision: Decision{
			Pods: PodsDecision{
				Faulty:                    true,
				States:                    states,
				EvictionRequestedPodNames: []string{"some-pod-hostname"},
			},
			Service: ServiceDecision{
				States: states,
			},
		},
		Info: &Info{
			PodsInfo: map[string]*pods.PodInfo{
				"some-pod-hostname": {
					PodID:    "some-pod",
					Cluster:  "sas",
					NodeID:   "some-node-id",
					Itype:    "default",
					HostName: "some-pod-hostname",
				},
			},
			ServiceInfo: &ServiceInfo{},
		},
		Config: &GeneralTemplateConfig{},
	}

	err := tmpl.Init()
	require.NoError(suite.T(), err)

	buf := new(bytes.Buffer)
	err = generalTemplate.Execute(buf, tmpl.Data)
	require.NoError(suite.T(), err)
}

func TestGeneralTemplateTestSuite(t *testing.T) {
	suite.Run(t, new(GeneralTemplateTestSuite))
}
