package samples

import (
	"a.yandex-team.ru/infra/temporal/workflows/common"
	"fmt"
	"go.temporal.io/sdk/workflow"
	"time"
)

func SleepingWorkflow(ctx workflow.Context, duration time.Duration) error {
	err := workflow.Sleep(ctx, duration)
	if err != nil {
		return err
	}
	return nil
}

func PoolMultiParallelChildWorkflow(ctx workflow.Context, duration time.Duration, childrenCount, windowSize int) error {
	runID := workflow.GetInfo(ctx).WorkflowExecution.RunID

	pool := common.NewChildWorkflowPool(ctx, 2)
	children := []int{}
	c := 0
	for c < childrenCount {
		children = append(children, c)
		c += 1
	}

	for _, c := range children {
		cwo := workflow.ChildWorkflowOptions{
			WorkflowID: fmt.Sprintf("sleeping-workflow(%d, %s)", c, runID),
		}
		_, _ = pool.ExecuteChildWorkflow(cwo, SleepingWorkflow, getDurationPlusMinusRandom(ctx, duration))
	}

	return pool.Wait()
}
