package processor

import (
	"time"

	"a.yandex-team.ru/infra/temporal/clients/startrek"
)

type ResponsibleKind int

const (
	AbcSchedule ResponsibleKind = iota
	Logins
)

type Responsible struct {
	Kind ResponsibleKind

	// AbcScheduleID is used if Kind == AbcSchedule
	AbcScheduleID int

	// Logins are used if Kind == Logins
	Logins []string
}

type RetryInvocationKind int

const (
	Period RetryInvocationKind = iota
	Once
	// like period, but summon only after ack signal
	AckPeriod
)

type RetryInvocationSettings struct {
	Kind RetryInvocationKind

	// Period is used if Kind == Period or AckPeriod
	Period time.Duration

	SummonOnNonWorkingHours bool
}

type InfraDutyInvocationSettings struct {
	AbcScheduleID int
	Text          string
}

type InvocationSettings struct {
	Responsible             Responsible
	RetryInvocationSettings RetryInvocationSettings
	Text                    string
}

type Problem struct {
	Ticket                      startrek.Ticket
	InvocationSettings          InvocationSettings
	InfraDutyInvocationSettings *InfraDutyInvocationSettings
}
