package processor

import (
	"strconv"
	"time"

	"a.yandex-team.ru/infra/temporal/clients/startrek"

	"go.temporal.io/sdk/temporal"
	"go.temporal.io/sdk/workflow"
)

type UpdateProblemSignal struct {
	Problem Problem
	Notify  bool
}

type CommentProblemSignal struct {
	Comment startrek.Comment
}

func ProcessWorkflow(ctx workflow.Context, problem Problem) error {
	options := workflow.ActivityOptions{
		StartToCloseTimeout: time.Hour * 24 * 365,
		RetryPolicy: &temporal.RetryPolicy{
			InitialInterval:        time.Second * 30,
			BackoffCoefficient:     1.0,
			MaximumInterval:        time.Minute,
			MaximumAttempts:        10,
			NonRetryableErrorTypes: []string{"PermanentError"},
		},
		HeartbeatTimeout: time.Minute * 10,
	}
	ctx = workflow.WithActivityOptions(ctx, options)

	v := workflow.GetVersion(ctx, "AWACS-1185", workflow.DefaultVersion, 2)
	err := workflow.SetQueryHandler(ctx, "current_version", func() (string, error) {
		return strconv.Itoa(int(v)), nil
	})
	if err != nil {
		return err
	}
	if v == workflow.DefaultVersion {
		return processWorkflowV1(ctx, problem)
	} else {
		return processWorkflowV2(ctx, problem, "")
	}
}

func ContinueProcessingWorkflow(ctx workflow.Context, startrekKey startrek.TicketKey, problem Problem) error {
	options := workflow.ActivityOptions{
		StartToCloseTimeout: time.Hour * 24 * 365,
		RetryPolicy: &temporal.RetryPolicy{
			InitialInterval:        time.Second * 30,
			BackoffCoefficient:     1.0,
			MaximumInterval:        time.Minute,
			MaximumAttempts:        10,
			NonRetryableErrorTypes: []string{"PermanentError"},
		},
		HeartbeatTimeout: time.Minute * 10,
	}
	ctx = workflow.WithActivityOptions(ctx, options)
	return processWorkflowV2(ctx, problem, startrekKey)
}
