package processor

import (
	"fmt"

	"a.yandex-team.ru/infra/temporal/activities/startreker"
	"a.yandex-team.ru/infra/temporal/clients/startrek"
	"go.temporal.io/sdk/workflow"
)

func Summon(ctx workflow.Context, a *startreker.Activities, problem Problem, key startrek.TicketKey) error {
	var summonees = make([]string, 0)
	switch problem.InvocationSettings.Responsible.Kind {
	case Logins:
		summonees = problem.InvocationSettings.Responsible.Logins
	case AbcSchedule:
		err := workflow.ExecuteActivity(ctx, a.GetOnDuty, problem.InvocationSettings.Responsible.AbcScheduleID).Get(ctx, &summonees)
		if err != nil {
			return fmt.Errorf("failed to get on duty: %w", err)
		}
	}

	comment := startrek.Comment{
		Text:      problem.InvocationSettings.Text,
		Summonees: summonees,
	}
	err := workflow.ExecuteActivity(ctx, a.CommentTicket, key, comment).Get(ctx, nil)
	if err != nil {
		return err
	}
	return nil
}
