package processor

import (
	"a.yandex-team.ru/infra/temporal/activities/startreker"
	"a.yandex-team.ru/infra/temporal/clients/startrek"
	"context"
	"github.com/stretchr/testify/suite"
	"go.temporal.io/sdk/workflow"
	"testing"
	"time"

	"github.com/stretchr/testify/mock"
	"github.com/stretchr/testify/require"
	"go.temporal.io/sdk/testsuite"
)

var a *startreker.Activities

type UnitTestSuite struct {
	suite.Suite
	testsuite.WorkflowTestSuite

	env *testsuite.TestWorkflowEnvironment
}

func (s *UnitTestSuite) SetupTest() {
	s.env = s.NewTestWorkflowEnvironment()
}

func (s *UnitTestSuite) AfterTest(suiteName, testName string) {
	s.env.AssertExpectations(s.T())
}

func WTestTicketClosedWorkflow(ctx workflow.Context) error {
	options := workflow.ActivityOptions{
		StartToCloseTimeout: time.Second,
		HeartbeatTimeout:    time.Minute * 10,
	}
	ctx = workflow.WithActivityOptions(ctx, options)
	problem := Problem{
		Ticket: startrek.Ticket{
			Summary:     "Summary",
			Description: "Description",
			Queue:       &startrek.Queue{Key: "TEST"},
			Tags:        []string{"tmp"},
			Parent:      &startrek.Parent{Key: "TEST-555"},
		},
		InvocationSettings: InvocationSettings{
			Responsible: Responsible{
				Kind:   Logins,
				Logins: []string{"ferenets"},
			},
			RetryInvocationSettings: RetryInvocationSettings{
				Kind:   Period,
				Period: time.Minute,
			},
			Text: "Hi",
		},
		InfraDutyInvocationSettings: &InfraDutyInvocationSettings{
			AbcScheduleID: 2824,
			Text:          "Привет!\nНужна твоя помощь, как дежурного awacs",
		},
	}

	return processWorkflowV2(ctx, problem)
}

func (s *UnitTestSuite) Test_StartrekerWorkflow() {
	testKey := startrek.TicketKey("TEST-1234")
	s.env.OnActivity(a.CreateTicket, mock.Anything).Return(
		func(ticket *startrek.Ticket) (startrek.TicketKey, error) {
			return testKey, nil
		},
	)
	s.env.OnActivity(a.CommentTicket, mock.Anything, mock.Anything).Return(
		func(key startrek.TicketKey, comment startrek.Comment) error {
			require.Equal(s.T(), testKey, key)
			return nil
		},
	)
	s.env.OnActivity(a.WaitUntilTicketClosed, mock.Anything, mock.Anything).Return(
		func(ctx context.Context, key startrek.TicketKey) (bool, error) {
			return true, nil
		},
	)
	s.env.RegisterWorkflow(WTestTicketClosedWorkflow)
	s.env.ExecuteWorkflow(WTestTicketClosedWorkflow)
	s.True(s.env.IsWorkflowCompleted())

	err := s.env.GetWorkflowError()
	s.NoError(err)
}

func TestUnitTestSuite(t *testing.T) {
	suite.Run(t, new(UnitTestSuite))
}
