package gc

import (
	acts "a.yandex-team.ru/infra/temporal/activities/yd/ri"
	"a.yandex-team.ru/yp/go/proto/ypapi"
	"go.temporal.io/sdk/workflow"
	"k8s.io/client-go/tools/cache"
)

var stageSelectors = []string{"/meta/id", "/spec/sox_service"}

func newStagesIndexer() cache.Indexer {
	return cache.NewIndexer(
		func(obj interface{}) (string, error) {
			return obj.(*ypapi.TStage).GetMeta().GetId(), nil
		},
		cache.Indexers{})
}

func fillStagesIndexer(activityCtx workflow.Context, a *acts.Activities, IDs []string, batchSize int, idxr cache.Indexer) error {
	for _, b := range byBatches(IDs, batchSize) {
		var stages []*ypapi.TStage
		err := workflow.ExecuteActivity(
			activityCtx,
			a.GetStagesByIDsActivity,
			b,
			stageSelectors,
		).Get(activityCtx, &stages)
		if err != nil {
			return err
		}
		for _, s := range stages {
			if err := idxr.Add(s); err != nil {
				return err
			}
		}
	}
	return nil
}
