#!/usr/bin/env python3
# -*- coding: utf-8 -*-

import setuptools
import sys

from sandbox_top.__version__ import version


class ReadmeCommand(setuptools.Command):

    description = "generate HTML readme"

    user_options = []

    def initialize_options(self):
        pass

    def finalize_options(self):
        pass

    def run(self):
        try:
            import markdown
        except ImportError:
            print((
                    "Python Markdown is required."
                    " Install it with `pip install markdown`."
                ),
                file=sys.stderr,
            )
        else:
            with open("README.markdown", "rt", encoding="utf-8") as readme_markdown:
                markdown_text = readme_markdown.read()
            html_body = markdown.markdown(
                text=markdown_text + "\n\nThe file is generated with `setup.py readme`.",
                output_format="html5",
            )
            with open("README.html", "wt", encoding="utf-8") as readme_html:
                readme_html.write((
                    "<!-- The file is generated - do not edit. -->"
                    "<!DOCTYPE html>"
                    "<html>"
                    "<head><meta charset=\"UTF-8\"><title>sandbox-top %s</title>%s</head>"
                    "<body>%s</body>"
                    "</html>"
                ) % (
                    version,
                    "<style>body { font-family: Tahoma, sans; } code { font-family: Consolas, monospace; }</style>",
                    html_body,
                ))


setuptools.setup(
    name="sandbox-top",
    version=version,
    packages=[
        "sandbox_top",
    ],
    entry_points={
        "console_scripts": [
            "sandbox-top = sandbox_top.main:entry_point",
        ],
    },
    cmdclass={
        "readme": ReadmeCommand,
    },
    zip_safe=True,
    author="eigenein@",
    author_email="eigenein@yandex-team.ru",
    description="Display Sandbox tasks",
    long_description=open("README.markdown", "rt").read(),
    keywords=["sandbox", "top"],
    url="https://github.yandex-team.ru/eigenein/sandbox-top",
    classifiers=[
        "Development Status :: 3 - Alpha",
        "Environment :: Console",
        "Environment :: Console :: Curses",
        "Intended Audience :: Developers",
        "Intended Audience :: System Administrators",
        "Operating System :: OS Independent",
        "Programming Language :: Python",
        "Programming Language :: Python :: 3",
    ],
)
