#include <infra/udp_click_metrics/libs/daemon/main.h>

#include <infra/libs/logger/log_printer.h>

#include <library/cpp/getopt/modchooser.h>

#include <util/generic/yexception.h>
#include <util/stream/output.h>

int main(int argc, const char* argv[]) {
    TModChooser modChooser;

    modChooser.AddMode("run",
                       NUdpClickMetrics::RunDaemon,
                       "Run udp_click_metrics daemon.");

    modChooser.AddMode("print_log",
                       NInfra::PrintEventLog,
                       "Run udp_click_metrics eventlog.");

    try {
        return modChooser.Run(argc, argv);
    } catch (...) {
        Cerr << CurrentExceptionMessage() << Endl;
        return EXIT_FAILURE;
    }

    return EXIT_SUCCESS;
}
