#include "main.h"

#include <infra/udp_click_metrics/libs/service/service.h>

#include <infra/libs/udp_metrics/daemon/main.h>

#include <library/cpp/json/json_writer.h>
#include <library/cpp/protobuf/json/proto2json.h>

namespace NUdpClickMetrics {

namespace {

void PrettyPrintConfig(const NUdpMetrics::TUdpMetricsServiceConfig& config) {
    NJson::TJsonWriter writer(&Cout, /* formatOutput */ true);
    NProtobufJson::Proto2Json(config, writer);
    Cout << Endl;
}

} // anonymous namespace

int RunDaemon(const NUdpMetrics::TUdpMetricsServiceConfig& config) {
    PrettyPrintConfig(config);
    return NUdpMetrics::RunDaemon<TService>(config);
}

int RunDaemon(const NProtoConfig::TLoadConfigOptions& options) {
    const auto config = NProtoConfig::LoadWithOptions<NUdpMetrics::TUdpMetricsServiceConfig>(options);
    return RunDaemon(config);
}

int RunDaemon(int argc, const char* argv[]) {
    const auto config = NProtoConfig::GetOpt<NUdpMetrics::TUdpMetricsServiceConfig>(argc, argv, "/udp_click_metrics/proto_config.json");
    return RunDaemon(config);
}

} // namespace NUdpClickMetrics
