#pragma once

#include <infra/libs/udp_metrics/api/api.pb.h>
#include <infra/libs/udp_metrics/service/service.h>

#include <infra/libs/logger/log_frame.h>

#include <metrika/uatraits/include/uatraits/detector.hpp>

namespace NUdpClickMetrics {

enum class EDeviceType {
    UNDEFINED /* "undefined" */,
    DESKTOP   /* "desktop" */,
    TABLET    /* "tablet" */,
    TOUCH     /* "touch" */,
    SMART     /* "smart" */
};

class TService: public NUdpMetrics::TService {
public:
    TService(const NUdpMetrics::TUdpMetricsServiceConfig& config);

private:
    NInfra::TRequestPtr<NUdpMetrics::NApi::TReqIncreaseMetrics> ParseUdpPacket(NUdp::TUdpPacket packet, NInfra::TLogFramePtr logFrame) const override;

private:
    NUdpMetrics::NApi::TMetric BaseMetric_;
    THolder<const uatraits::detector> DeviceDetector_;
};

} // namespace NUdpClickMetrics
