"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const fs_1 = require("fs");
const readArgs_1 = require("./readArgs");
const sandboxApi_1 = require("./sandboxApi");
const utils_1 = require("./utils");
const ypApi_1 = require("./ypApi");
const { title, resourceId, resourceType, targets, releaseType } = readArgs_1.releaseArguments;
utils_1.prettyLog(readArgs_1.releaseArguments);
const SANDBOX_TOKEN = process.env.SANDBOX_OAUTH_TOKEN;
const PROJECT_NAME = process.env.PROJECT_NAME;
const RELEASE_AUTHOR = process.env.RELEASE_AUTHOR;
const NANNY_SERVICE_ID = process.env.NANNY_SERVICE_ID;
async function createDeployRelease(resource) {
    const attributes = {
        key: resource.attributes.key,
        project: resource.attributes.project,
    };
    const releaseResource = {
        arch: 'any',
        attributes: attributes,
        description: resource.description,
        file_md5: resource.md5,
        filename: resource.file_name,
        resource_id: resource.id.toString(),
        skynet_id: resource.skynet_id,
        type: resource.type,
    };
    const release = {
        meta: { id: `${PROJECT_NAME}_${resourceId}` },
        spec: {
            sandbox: {
                release_author: RELEASE_AUTHOR,
                release_type: releaseType,
                resources: [releaseResource],
                task_author: RELEASE_AUTHOR,
                task_id: resource.task.id.toString(),
                task_type: 'TRENDBOX_CI_JOB_BETA',
                title,
            },
            title,
        },
    };
    console.log('Deploy release');
    utils_1.prettyLog(release);
    await ypApi_1.ypApiCreateObject('release', release);
}
async function createNannyRelease() {
    const { createRelease } = require('@yandex-int/trendbox-ci.nanny-workflow');
    const version = JSON.parse(fs_1.readFileSync('../ui/package.json', { encoding: 'utf8' })).version;
    const release = {
        title: `Release version ${version}`,
        resourceId,
        resourceType,
        releaseType,
        ensureDeploy: false,
        nannyServiceId: NANNY_SERVICE_ID,
        sandboxOwner: 'INFRACLOUDUI',
        sandboxToken: SANDBOX_TOKEN,
    };
    console.log('Nanny release');
    utils_1.prettyLog(release);
    await createRelease(release);
}
const targetHandlers = {
    deploy: createDeployRelease,
    nanny: createNannyRelease,
};
async function run() {
    const resource = await sandboxApi_1.sbApiGetResource(resourceId);
    // run parallel
    await Promise.all(targets.map(t => { var _a; return (_a = targetHandlers[t](resource)) !== null && _a !== void 0 ? _a : Promise.resolve(); }));
    return 'Done';
}
utils_1.waitPromise(run);
