"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.releaseArguments = void 0;
const tslib_1 = require("tslib");
// @ts-ignore
const arg_1 = tslib_1.__importDefault(require("arg"));
const Json = (v) => JSON.parse(v);
const JsonArray = (v) => Json(v);
const args = arg_1.default({
    '--title': String,
    '--resourceId': Number,
    '--resourceType': String,
    '--targets': JsonArray,
    '--releaseType': String,
});
const title = args['--title'];
if (!title) {
    throw new Error('missing required argument: --title');
}
const resourceId = args['--resourceId'];
if (!resourceId) {
    throw new Error('missing required argument: --resourceId');
}
const resourceType = args['--resourceType'];
if (!resourceType) {
    throw new Error('missing required argument: --resourceType');
}
const targets = args['--targets'];
if (!targets || targets.length === 0) {
    throw new Error('missing required argument: --targets');
}
const releaseType = args['--releaseType'];
if (!releaseType) {
    throw new Error('missing required argument: --releaseType');
}
exports.releaseArguments = {
    title,
    resourceId,
    resourceType,
    targets,
    releaseType,
};
