"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.sbApiGetResource = void 0;
const tslib_1 = require("tslib");
const node_fetch_1 = tslib_1.__importDefault(require("node-fetch"));
const SANDBOX_URL = 'https://sandbox.yandex-team.ru/api/v1.0/';
const SANDBOX_TOKEN = process.env.SANDBOX_OAUTH_TOKEN;
async function sbApi(method, urlPath, body) {
    return await node_fetch_1.default(`${SANDBOX_URL}${urlPath}`, {
        headers: {
            Accept: 'application/json',
            Authorization: `OAuth ${SANDBOX_TOKEN}`,
            'Content-Type': 'application/json',
        },
        method,
        body: body ? JSON.stringify(body) : undefined,
    });
}
async function sbApiGetResource(id) {
    const resp = await sbApi('GET', `/resource/${id}`);
    return (await resp.json());
}
exports.sbApiGetResource = sbApiGetResource;
