"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.prettyLog = exports.maskSecretFields = exports.waitPromise = void 0;
const tslib_1 = require("tslib");
const util_1 = tslib_1.__importDefault(require("util"));
/**
 * Функция предотвращает завершение процесса при запуске асинхронной задачи.
 *
 * Технически она держит event-loop не пустым, чтобы дать возможность асинхронной задаче выполниться.
 */
function waitPromise(run) {
    function wait() {
        setTimeout(wait, 1000);
    }
    run().then(r => {
        console.log(r);
        process.exit(0);
    }, e => {
        console.error(e);
        process.exit(1);
    });
    wait();
}
exports.waitPromise = waitPromise;
const colors = process.env.CI !== 'true';
function maskSecretFields(data) {
    if (data && data.constructor === Object) {
        const result = {};
        for (const field in data) {
            if (data.hasOwnProperty(field)) {
                if (field.match(/(token|key|secret|pass|password)$/i)) {
                    result[field] = '***';
                }
                else {
                    result[field] = maskSecretFields(data[field]);
                }
            }
        }
        return result;
    }
    if (data && Array.isArray(data)) {
        return data.map(maskSecretFields);
    }
    return data;
}
exports.maskSecretFields = maskSecretFields;
function prettyLog(data) {
    console.log(util_1.default.inspect(maskSecretFields(data), { depth: null, colors }));
}
exports.prettyLog = prettyLog;
