"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ypApiCreateObject = void 0;
const tslib_1 = require("tslib");
const node_fetch_1 = tslib_1.__importDefault(require("node-fetch"));
const utils_1 = require("./utils");
const YP_URL = 'https://deploy.yandex-team.ru/api_proxy/yp';
const ROBOT_YP_TOKEN = process.env.ROBOT_YP_TOKEN;
/**
 * Lite version of YpApi
 *
 * Adds required headers, parses errors from response
 *
 * @param urlPath
 * @param body
 */
async function ypApi(urlPath, body) {
    const response = await node_fetch_1.default(`${YP_URL}${urlPath}`, {
        headers: {
            Accept: 'application/json',
            Authorization: `OAuth ${ROBOT_YP_TOKEN}`,
            'Content-Type': 'application/json',
        },
        method: 'POST',
        body: JSON.stringify(body),
    });
    if (!response.ok) {
        if (response.headers.has('X-YT-Error')) {
            const error = JSON.parse(response.headers.get('X-YT-Error'));
            utils_1.prettyLog(error);
        }
        throw new Error(`Request failed "${response.status}: ${response.statusText}"`);
    }
    return response;
}
async function ypApiCreateObject(objectType, data) {
    const resp = await ypApi('/ObjectService/CreateObject', {
        object_type: objectType,
        attributes_payload: { yson: data },
    });
    return await resp.json();
}
exports.ypApiCreateObject = ypApiCreateObject;
