set -x
set -e

cd ui
bash ../.trendbox/jobs/common/npm_ci.sh

npm run build

# Publish to S3 (for E2E testing)
TRENDBOX_BRANCH_NORMALIZED="${TRENDBOX_BRANCH//[\#\/]/_}"
~/.local/bin/aws --endpoint-url=http://s3.mds.yandex.net \
   s3 sync ./build "s3://infracloudui-cdn/$PROJECT_NAME/$TRENDBOX_BRANCH_NORMALIZED/ui" --delete --exclude "*.map" ||
   echo "S3 upload failed"

# Make an archive with statics, presets, commands and nginx configs (for deploying)
mkdir ui_bundle
cp -r ./build ui_bundle/ui
cp -r ../configs/presets ui_bundle/presets
cp -r ../configs/commands ui_bundle/commands
cp -r ../configs/nginx ui_bundle/nginx
tar -czvf "$PWD/ui_bundle.tar.gz" ui_bundle

RESOURCE_ID=$(
   sandbox upload-resource "$PWD/ui_bundle.tar.gz" \
      --type="$UI_BUNDLE_RESOURCE_TYPE" \
      --description="ui_bundle" \
      --os-family="linux" \
      --attr-key="ui_bundle" \
      --attr-project="$PROJECT_NAME" \
      --output-format=unix
)
echo "Resource created $RESOURCE_ID"

# Output params
trendbox output resource_id "$RESOURCE_ID"
trendbox output done 'true'
