set -e

cd ui
bash ../.trendbox/jobs/common/npm_ci.sh

npm run build-storybook

TRENDBOX_BRANCH_NORMALIZED="${TRENDBOX_BRANCH//[\#\/]/_}"
~/.local/bin/aws --endpoint-url=http://s3.mds.yandex.net \
   s3 sync ./storybook-static "s3://infracloudui-cdn/$PROJECT_NAME/$TRENDBOX_BRANCH_NORMALIZED/storybook" --delete --exclude "*.svg" ||
   echo "S3 upload failed"

~/.local/bin/aws --endpoint-url=http://s3.mds.yandex.net \
   s3 sync ./storybook-static "s3://infracloudui-cdn/$PROJECT_NAME/$TRENDBOX_BRANCH_NORMALIZED/storybook" --exclude "*" --include "*.svg" --content-type "image/svg+xml" ||
   echo "S3 upload failed"

trendbox publish-report ./storybook-static --ttl=14 --main=index.html

# Output params
trendbox output done 'true'
