set -e

# Get version-agnostic hash of lock-file
PACKAGE_LOCK_HASH=$(cat package-lock.json | sed -E 's/^  "version".+$//g' | shasum | awk '{print $1}')

# Check cache status. "Warming" if need
trendbox cache ./node_modules --cache-key="$PACKAGE_LOCK_HASH" --ttl=14d -- npm ci --unsafe-perm --legacy-peer-deps
