set -e

cd cypress
bash ../.trendbox/jobs/common/npm_ci.sh

npx cypress install # TODO move to container itself
npx cypress verify

echo "127.0.0.1 localhost.yandex-team.ru" >>/etc/hosts
echo "$LOCALHOST_SSL_CRT" | base64 -d >../configs/localhost.yandex-team.ru.crt
echo "$LOCALHOST_SSL_KEY" | base64 -d >../configs/localhost.yandex-team.ru.key

npm run ci

trendbox publish-report ./results/html --ttl=14 --main=index.html

TRENDBOX_BRANCH_NORMALIZED="${TRENDBOX_BRANCH//[\#\/]/_}"
~/.local/bin/aws --endpoint-url=http://s3.mds.yandex.net \
   s3 sync ./results/html s3://infracloudui-cdn/$PROJECT_NAME/$TRENDBOX_BRANCH_NORMALIZED/e2e-report --delete --exclude "*.map" ||
   echo "S3 upload failed"

# Output params
trendbox output done 'true'
