set -e

COMMIT_MESSAGE=$(git log --pretty=format:"%s")

case $COMMIT_MESSAGE in
*--release*)
  export NEED_BUILD=true
  export NEED_E2E=true
  export NEED_RELEASE=true
  ;;
*--e2e*)
  export NEED_BUILD=true
  export NEED_E2E=true
  export NEED_RELEASE=false
  ;;
*--build*)
  export NEED_BUILD=true
  export NEED_E2E=false
  export NEED_RELEASE=false
  ;;
*)
  export NEED_BUILD=false
  export NEED_E2E=false
  export NEED_RELEASE=false
  ;;
esac

echo "Commit message: $COMMIT_MESSAGE"
echo NEED_BUILD=$NEED_BUILD
echo NEED_E2E=$NEED_E2E
echo NEED_RELEASE=$NEED_RELEASE

if [ "$NEED_BUILD" = true ]; then
  cd ui
  bash ../.trendbox/jobs/common/npm_ci.sh # Create cache for /ui/node_modules
fi

# Output params
trendbox output need_build "$NEED_BUILD"
trendbox output start_e2e "$NEED_E2E"

if [ "$NEED_RELEASE" = true ]; then
  trendbox output release_targets "[\"deploy\", \"nanny\"]"
else
  trendbox output release_targets "[\"deploy\"]"
fi

