// @ts-ignore
import arg from 'arg';

const Json = <T>(v: string) => JSON.parse(v) as T;

const JsonArray = (v: string) => Json<string[]>(v);

const args = arg({
   '--title': String,
   '--resourceId': Number,
   '--resourceType': String,
   '--targets': JsonArray,
   '--releaseType': String,
});

const title: string | undefined = args['--title'];
if (!title) {
   throw new Error('missing required argument: --title');
}

const resourceId: number | undefined = args['--resourceId'];
if (!resourceId) {
   throw new Error('missing required argument: --resourceId');
}

const resourceType: number | undefined = args['--resourceType'];
if (!resourceType) {
   throw new Error('missing required argument: --resourceType');
}

const targets: string[] | undefined = args['--targets'];
if (!targets || targets.length === 0) {
   throw new Error('missing required argument: --targets');
}

const releaseType: string | undefined = args['--releaseType'];
if (!releaseType) {
   throw new Error('missing required argument: --releaseType');
}

export const releaseArguments = {
   title,
   resourceId,
   resourceType,
   targets,
   releaseType,
};
