import fetch from 'node-fetch';

const SANDBOX_URL = 'https://sandbox.yandex-team.ru/api/v1.0/';
const SANDBOX_TOKEN = process.env.SANDBOX_OAUTH_TOKEN;

async function sbApi(method: 'GET' | 'POST', urlPath: string, body?: any) {
   return await fetch(`${SANDBOX_URL}${urlPath}`, {
      headers: {
         Accept: 'application/json',
         Authorization: `OAuth ${SANDBOX_TOKEN}`,
         'Content-Type': 'application/json',
      },
      method,
      body: body ? JSON.stringify(body) : undefined,
   });
}

export interface SandboxResource {
   arch: string;
   attributes: Record<string, string|number>;
   description: string;
   executable: boolean;
   file_name: string;
   for_parent: null;
   http: { proxy: string; links: string[] };
   id: number;
   md5: string;
   mds: null;
   multifile: boolean;
   owner: string;
   rights: string;
   rsync: { proxy: null; links: string[] };
   size: number;
   skynet_id: string;
   sources: string[];
   state: string;
   task: { id: number; url: string; status: string };
   time: { expires: string; created: string; accessed: string; updated: string };
   type: string;
   url: string;
}

export async function sbApiGetResource(id: number) {
   const resp = await sbApi('GET', `/resource/${id}`);

   return (await resp.json()) as SandboxResource;
}
