import util from 'util';

/**
 * Функция предотвращает завершение процесса при запуске асинхронной задачи.
 *
 * Технически она держит event-loop не пустым, чтобы дать возможность асинхронной задаче выполниться.
 */
export function waitPromise(run: () => Promise<any>) {
   function wait() {
      setTimeout(wait, 1000);
   }

   run().then(
      r => {
         console.log(r);
         process.exit(0);
      },
      e => {
         console.error(e);
         process.exit(1);
      },
   );

   wait();
}

const colors = process.env.CI !== 'true';

export function maskSecretFields(data: any): any {
   if (data && data.constructor === Object) {
      const result: Record<string, any> = {};
      for (const field in data) {
         if (data.hasOwnProperty(field)) {
            if (field.match(/(token|key|secret|pass|password)$/i)) {
               result[field] = '***';
            } else {
               result[field] = maskSecretFields(data[field]);
            }
         }
      }

      return result;
   }

   if (data && Array.isArray(data)) {
      return data.map(maskSecretFields);
   }

   return data;
}

export function prettyLog(data: any) {
   console.log(util.inspect(maskSecretFields(data), { depth: null, colors }));
}
