import fetch from 'node-fetch';
import { prettyLog } from './utils';

const YP_URL = 'https://deploy.yandex-team.ru/api_proxy/yp';
const ROBOT_YP_TOKEN = process.env.ROBOT_YP_TOKEN;

/**
 * Lite version of YpApi
 *
 * Adds required headers, parses errors from response
 *
 * @param urlPath
 * @param body
 */
async function ypApi(urlPath: string, body: any) {
   const response = await fetch(`${YP_URL}${urlPath}`, {
      headers: {
         Accept: 'application/json',
         Authorization: `OAuth ${ROBOT_YP_TOKEN}`,
         'Content-Type': 'application/json',
      },
      method: 'POST',
      body: JSON.stringify(body),
   });

   if (!response.ok) {
      if (response.headers.has('X-YT-Error')) {
         const error = JSON.parse(response.headers.get('X-YT-Error')!);
         prettyLog(error);
      }

      throw new Error(`Request failed "${response.status}: ${response.statusText}"`);
   }

   return response;
}

export async function ypApiCreateObject(objectType: string, data: any) {
   const resp = await ypApi('/ObjectService/CreateObject', {
      object_type: objectType,
      attributes_payload: { yson: data },
   });

   return await resp.json();
}

export interface ReleaseResource {
   arch: string;
   /**
    *  Attributes of sandbox resource, e.g.
    *    "backup_task": "577303390",
    *    "released": "testing",
    *    "ttl": "inf",
    *    "version": "1.200"
    */
   attributes: Record<string, string>;
   description: string;
   file_md5: string;
   /**
    *  Resource bundle specific field. Resource will be mounted to
    *  path "<directory>/<filename>" where <directory> is resource bundle directory
    */
   filename: string;
   http_url: string;
   releasers: string[];
   resource_id: string;
   skynet_id: string;
   type: string;
}
