import json
import os
import re
import sys

preset = os.environ.get('CONFIG_PRESET') or 'prod'

def read_file(path):
    with open(path, 'r') as f:
        result = f.read()
        f.close()
    return result


def read_json(path):
    return json.loads(read_file(path))


def write_file(path, content):
    with open(path, 'w') as f:
        f.write(content)


def get_config():
    body = read_file('../presets/{preset}.json'.format(preset=preset))

    return json.loads(body)


def patch_file(path, body_patcher):
    if not os.path.isfile(path):
        print('File {path} not found'.format(path=path))
        print('Current working directory is', os.path.curdir)

    body = read_file(path)
    patched_body = body_patcher(body)
    write_file(path, patched_body)


html_file = sys.argv[1] or 'index.html'

script_template = """<script id="CONFIG">
 (function () {{
     // CONFIG
     const config = `{REACT_APP_CONFIG}`;
     window.CONFIG = JSON.parse(config);
     window.REACT_APP_METRIKA = `{REACT_APP_METRIKA}`;
 }}());
</script>"""

config = get_config()


def patcher(body):
    script_re = re.compile(r'<script id=\"CONFIG\">.+?</script>', re.S)

    content = script_template.format(
        REACT_APP_CONFIG=json.dumps(config, indent=2),
        REACT_APP_METRIKA=os.environ.get('REACT_APP_METRIKA') or ""
    )

    return script_re.sub(content, body)


patch_file(html_file, patcher)

print('{html_file} has been patched with {preset} config'.format(html_file=html_file, preset=preset))
