const fs = require('fs');

const endpoints = {
   staff: {
      prod: 'https://staff-api.yandex-team.ru',
   },
   abc: {
      prod: 'https://abc-back.yandex-team.ru',
      proxy: 'https://deploy-testing.yandex-team.ru/api_proxy/abc',
   },
   awacs: {
      prod: 'https://awacs.yandex-team.ru',
      test: 'https://test-awacs.n.yandex-team.ru',
      proxy: 'https://deploy-testing.yandex-team.ru/api_proxy/awacs',
      testProxy: 'https://deploy-testing.yandex-team.ru/api_proxy/awacs_test',
   },
   yp: {
      prod: 'https://xdc.yp.yandex-team.ru:8443',
      test: 'https://sas-test.yp.yandex-team.ru:8443',
      manPre: 'https://man-pre.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp',
   },
   yp_sas_test: {
      prod: 'https://sas-test.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_sas_test',
   },
   yp_sas: {
      prod: 'https://sas.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_sas',
   },
   yp_man: {
      prod: 'https://man.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_man',
   },
   yp_man_pre: {
      prod: 'https://man-pre.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_man_pre',
   },
   yp_vla: {
      prod: 'https://vla.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_vla',
   },
   yp_iva: {
      prod: 'https://iva.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_iva',
   },
   yp_myt: {
      prod: 'https://myt.yp.yandex-team.ru:8443',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/yp_myt',
   },
   deploy: {
      prod: 'https://ui-proxy.deploy.yandex-team.ru',
      dev: 'https://dev-ui-proxy.deploy.yandex-team.ru',
      pre: 'https://pre-ui-proxy.deploy.yandex-team.ru',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/dproxy',
   },
   logs: {
      prod: 'https://ui-proxy.deploy.yandex-team.ru',
      dev: 'https://dev-ui-proxy.deploy.yandex-team.ru',
      pre: 'https://pre-ui-proxy.deploy.yandex-team.ru',
      proxy: 'https://deploy.yandex-team.ru/api_proxy/dproxy',
   },
   yasm: {
      prod: 'https://yasm.yandex-team.ru',
   },
   deploy_auth: {
      prod: 'https://deploy-auth.yandex-team.ru',
      pre: 'https://deploy-auth-pre.yandex-team.ru',
      test: 'https://deploy-auth-test.yandex-team.ru',
   },
   startrek: {
      prod: 'https://st-api.yandex-team.ru',
   },
   sandbox: {
      prod: 'https://sandbox.yandex-team.ru',
   },
   infra: {
      prod: 'https://infra-api.yandex-team.ru',
   },
   infra_components: {
      prod: 'https://sidecars-updater.in.yandex-team.ru',
      pre: 'https://sidecars-updater-pre.in.yandex-team.ru',
      test: 'https://sidecars-updater-test.in.yandex-team.ru',
      dev: 'https://sidecars-updater-test.in.yandex-team.ru',
   },
   solomon: {
      prod: 'https://solomon.yandex-team.ru',
      pre: 'https://solomon.yandex-team.ru',
      test: 'https://solomon.yandex-team.ru',
      dev: 'https://solomon.yandex-team.ru',
   },
   xray: {
      prod: 'https://xray.sec.yandex-team.ru',
   },
   project_manager: {
      prod: 'https://pm.yandex-team.ru',
   },
   infra_doctor: {
      prod: 'https://infra-doctor.yandex-team.ru',
   }
};

const endpointsData = Object.keys(endpoints).reduce((data, name) => {
   data[name] = Object.keys(endpoints[name]).reduce((envs, env) => {
      envs[env] = {
         name,
         endpoint: endpoints[name][env],
      };
      return envs;
   }, {});
   return data;
}, {});

const defaultEndpoints = Object.keys(endpointsData)
   .filter(name => !name.startsWith('yp'))
   .reduce((data, name) => {
      data[name] = endpointsData[name].prod || Object.values(endpointsData[name])[0];
      return data;
   }, {});

const clusters = {
   sas: 'SAS',
   man: 'MAN',
   vla: 'VLA',
   iva: 'IVA',
   myt: 'MYT',
   'sas-test': 'TEST_SAS',
   'man-pre': 'MAN_PRE',
};

const clustersData = Object.keys(clusters).reduce((data, name) => {
   data[name] = {
      value: name,
      title: clusters[name],
   };
   return data;
}, {});

const deployRobots = {
   drug: 'robot-drug-deploy',
   test: 'robot-deploy-test',
};

const idmSystemName = {
   prod: 'deploy-prod',
   test: 'deploy-test',
   pre: 'deploy-pre',
};

const nannyUiDomain = {
   prod: 'https://nanny.yandex-team.ru/ui/#',
   dev: 'https://dev-nanny.yandex-team.ru/ui/#',
};

const deployEngine = {
   prod: 'env_controller',
   acceptance: 'acceptance_controller',
};

const serviceWorkerRefreshIntervalMinutes = {
   prod: 10,
   local: 0.5,
};

const yasmPush = {
   prod: 'https://deploy.yandex-team.ru/api_proxy/push/',
   test: 'https://deploy-testing.yandex-team.ru/api_proxy/push/',
};

const clck = {
   prod: 'https://deploy.yandex-team.ru/api_proxy/clck/click',
   test: 'https://deploy-testing.yandex-team.ru/api_proxy/clck/click',
};

const defaultSettings = {
   blackboxHost: 'blackbox.yandex-team.ru',
   passportHost: 'https://passport.yandex-team.ru',
   authorizePath: 'https://passport.yandex-team.ru/passport?mode=auth&retpath=',
   resignPath: 'https://pass.yandex-team.ru/resign?retpath=',
   avatarHost: 'https://center.yandex-team.ru',
   feedbackFormId: 47538,
   overrideGeoLocation: {
      iva: 'msk',
      myt: 'msk',
      'man-pre': 'man',
   },
   lostClusters: ['man'],
};

// environments

// production
const extProd = {
   envName: 'ext-prod',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.prod,
   deployEngine: deployEngine.prod,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.prod,
   idmSystemName: idmSystemName.prod,
   yasmPush: yasmPush.prod,
   clck: clck.prod,
   clusters: [clustersData.sas, clustersData.vla, clustersData.man, clustersData.iva, clustersData.myt],
   deployRobots: [deployRobots.drug],
   services: [
      ...Object.values(defaultEndpoints),
      endpointsData.yp.prod,
      endpointsData.yp_sas.prod,
      endpointsData.yp_man.prod,
      endpointsData.yp_vla.prod,
      endpointsData.yp_iva.prod,
      endpointsData.yp_myt.prod,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

const extAcceptance = {
   envName: 'ext-acceptance',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.dev,
   deployEngine: deployEngine.acceptance,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.prod,
   idmSystemName: idmSystemName.prod,
   yasmPush: yasmPush.prod,
   clck: clck.prod,
   clusters: [clustersData.sas, clustersData.vla, clustersData.man, clustersData.iva, clustersData.myt],
   deployRobots: [deployRobots.drug, deployRobots.test], // почему?
   services: [
      ...Object.values({
         ...defaultEndpoints,
         awacs: endpointsData.awacs.test, // почему?
         deploy: endpointsData.deploy.prod,
         logs: endpointsData.logs.prod,
         infra_components: endpointsData.infra_components.test,
         solomon: endpointsData.solomon.test,
         project_manager: endpointsData.project_manager.prod,
      }),
      endpointsData.yp.prod,
      endpointsData.yp_sas.prod,
      endpointsData.yp_man.prod,
      endpointsData.yp_vla.prod,
      endpointsData.yp_iva.prod,
      endpointsData.yp_myt.prod,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

// testing
const extTest = {
   envName: 'ext-test',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.dev,
   deployEngine: deployEngine.prod,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.prod,
   idmSystemName: idmSystemName.test,
   yasmPush: yasmPush.test,
   clck: clck.test,
   clusters: [clustersData['sas-test'], clustersData['man-pre']],
   deployRobots: [deployRobots.drug, deployRobots.test],
   services: [
      ...Object.values({
         ...defaultEndpoints,
         awacs: endpointsData.awacs.test,
         deploy: endpointsData.deploy.dev,
         logs: endpointsData.logs.dev,
         deploy_auth: endpointsData.deploy_auth.test,
         infra_components: endpointsData.infra_components.test,
         solomon: endpointsData.solomon.test,
         project_manager: endpointsData.project_manager.prod,
      }),
      endpointsData.yp.test,
      endpointsData.yp_sas.prod,
      endpointsData.yp_man.prod,
      endpointsData.yp_vla.prod,
      endpointsData.yp_iva.prod,
      endpointsData.yp_myt.prod,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

// pre
const extPre = {
   envName: 'ext-pre',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.dev,
   deployEngine: deployEngine.prod,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.prod,
   idmSystemName: idmSystemName.prod,
   yasmPush: yasmPush.prod,
   clck: clck.prod,
   clusters: [clustersData.sas, clustersData.vla, clustersData.man, clustersData.iva, clustersData.myt],
   deployRobots: [deployRobots.drug],
   services: [
      ...Object.values({
         ...defaultEndpoints,
         awacs: endpointsData.awacs.proxy,
         deploy: endpointsData.deploy.prod,
         logs: endpointsData.logs.prod,
         infra_components: endpointsData.infra_components.pre,
         solomon: endpointsData.solomon.pre,
         project_manager: endpointsData.project_manager.prod,
      }),
      endpointsData.yp.prod,
      endpointsData.yp_sas.prod,
      endpointsData.yp_man.prod,
      endpointsData.yp_vla.prod,
      endpointsData.yp_iva.prod,
      endpointsData.yp_myt.prod,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

const extManPre = {
   envName: 'ext-man-pre',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.dev,
   deployEngine: deployEngine.prod,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.prod,
   idmSystemName: idmSystemName.pre,
   yasmPush: yasmPush.prod,
   clck: clck.prod,
   clusters: [clustersData['sas-test'], clustersData['man-pre']],
   deployRobots: [deployRobots.drug, deployRobots.test],
   services: [
      ...Object.values({
         ...defaultEndpoints,
         awacs: endpointsData.awacs.test,
         deploy: endpointsData.deploy.pre,
         logs: endpointsData.logs.pre,
         deploy_auth: endpointsData.deploy_auth.pre,
         infra_components: endpointsData.infra_components.pre,
         solomon: endpointsData.solomon.pre,
         project_manager: endpointsData.project_manager.prod,
      }),
      endpointsData.yp.manPre,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

const extLocal = {
   envName: 'ext-local',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.prod,
   deployEngine: deployEngine.prod,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.local,
   idmSystemName: idmSystemName.prod,
   yasmPush: yasmPush.test,
   clck: clck.test,
   clusters: [clustersData.sas, clustersData.vla, clustersData.man, clustersData.iva, clustersData.myt],
   deployRobots: [deployRobots.drug],
   services: [
      ...Object.values({
         ...defaultEndpoints,
         abc: endpointsData.abc.proxy,
         awacs: endpointsData.awacs.proxy,
         deploy: endpointsData.deploy.prod,
         logs: endpointsData.logs.prod,
         deploy_auth: endpointsData.deploy_auth.prod,
         infra_components: endpointsData.infra_components.dev,
         solomon: endpointsData.solomon.dev,
         project_manager: endpointsData.project_manager.prod,
      }),
      endpointsData.yp.prod,
      endpointsData.yp_sas.prod,
      endpointsData.yp_man.prod,
      endpointsData.yp_vla.prod,
      endpointsData.yp_iva.prod,
      endpointsData.yp_myt.prod,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

const extLocalTest = {
   envName: 'ext-local-test',
   ...defaultSettings,
   nannyUiDomain: nannyUiDomain.dev,
   deployEngine: deployEngine.prod,
   serviceWorkerRefreshIntervalMinutes: serviceWorkerRefreshIntervalMinutes.local,
   idmSystemName: idmSystemName.test,
   yasmPush: yasmPush.test,
   clck: clck.test,
   clusters: [clustersData['sas-test'], clustersData['man-pre']],
   deployRobots: [deployRobots.drug, deployRobots.test],
   services: [
      ...Object.values({
         ...defaultEndpoints,
         abc: endpointsData.abc.proxy,
         awacs: endpointsData.awacs.testProxy,
         deploy: endpointsData.deploy.dev,
         logs: endpointsData.logs.dev,
         deploy_auth: endpointsData.deploy_auth.test,
         infra_components: endpointsData.infra_components.test,
         solomon: endpointsData.solomon.test,
         project_manager: endpointsData.project_manager.prod,
      }),
      endpointsData.yp.test,
      endpointsData.yp_sas_test.prod,
      endpointsData.yp_man_pre.prod,
   ],
};

const envs = [extProd, extTest, extPre, extManPre, extLocal, extLocalTest, extAcceptance];

for (const env of envs) {
   fs.writeFileSync(`${__dirname}/${env.envName}.json`, JSON.stringify(env, null, 2));
}
