# Как запустить тесты Cypress локально

Для начала убедитесь, что вы умеете запускать сам проект и сторибук.

Для локальной работы Cypress нужно настроить переменные окружения:
* __Логин/пароль для робота__, из-под которого будут запускаться тесты. Пароль взять в [секретнице](https://yav.yandex-team.ru/secret/sec-01d7mk270pmfgtqje2y6m23ksx/explore/versions), логин - в комментариях к секрету.
* __Базовый URL__ (для самого __проекта__) и __адрес сторибука__.
   Запустите проект и сторибук и посмотрите, на каком адресе они находятся.

Узнав всё это, нужно проставить переменные окружения, на Маке это делается так:
* Открыть файл `~/.zshenv` и вписать:
```shell
export ROBOT_LOGIN="/*логин робота*/"
export ROBOT_PASSWORD="/*пароль робота*/"
export CYPRESS_BASE_URL=https://localhost.yandex-team.ru:9999
export CYPRESS_storybookHost=https://localhost.yandex-team.ru:9997
export CYPRESS_disabledLocations=["myt"]
export CYPRESS_service="/* frontend/backend */"

```
Если вдруг у вас другие адреса, поставьте свои. __Не трогайте конфиг Cypress `cypress.json`!__
Он используется для тестирования в облаке, и всё cломается, если поменять `baseUrl` и `storybookHost`.

При необходимости (учения, регламентные работы, проблемы с квотой в отдельных локациях) можно временно подменять у себя в переменных окружения настройки disabledLocations. Желательно, чтобы такая локация была только одна (она используется в некоторых тестах), тогда стейджи в тестах будут подниматься быстрее.

Теперь переходим в папку `cypress/`, устанавливаем всё нужное и запускаем Cypress.
```shell
cd cypress
npm i
npm run cypress
```
Убедитесь, что у вас запущен проект и сторибук!

## Запустить тесты параллельно в headless моде

В облаке тесты запускаются параллельно и без реальных окошек (headless mode).

__Важно!__ Все тесты должны уметь запускаться параллельно, то есть должны быть независимы друг от друга, не конфликтовать и не зависеть от порядка их выполнения.
Например, нельзя в двух разных тестах использовать одни и те же имена стейджей или проектов.

Запустить тесты таким образом можно и локально:

```shell
# Вы здесь: .../deploy/cypress
npm run ci
```

Убедитесь, что у вас запущен проект и сторибук.

Эти тесты складывают и получают статистику выполнения в S3 (чтобы оптимизировать время тестирования), поэтому если тесты не работают, попробуйте установить еще одну переменную окружения:
```shell
# Дописать в ~/.zshenv
export TRENDBOX_BRANCH=develop
```
*TODO: объяснить, на что влияет $TRENDBOX_BRANCH*

## Как лечить проблемы

__Не отчаивайтесь.__ Прежде чем паниковать, попробуйте ~~выключить и включить~~ переустановать пакеты для Cypress и пакеты для самого проекта:
```shell
# Вы здесь: .../deploy/cypress
rm -rf node_modules/
cd ../ui
rm -rf node_modules/
npm i
cd ../cypress
npm i
```
__Не работают тесты для сторибука.__ Убедитесь, что вы его включили. Убедитесь, что в `CYPRESS_storybookHost` нет `/` на конце.

__Не получается удалить стейдж/проект.__ Если часто создавать/удалять проект/стейдж, то могут залипать права, и у робота может не быть прав на свой собственный проект. В таком случае нужен робот на стероидах: пароль в [секретнице](https://yav.yandex-team.ru/secret/sec-01d48v48n03efsc4cnc2e2ejfh/explore/versions), логин - в комментариях к секрету. Пользуйтесь только в крайних случаях и очень осторожно, а то _наделаете дел_.

## Рекомендации по разработке
Все тесты используют элементы на странице с помощью селекторов. Не завязываемся на классы, на конкретные теги, используем только data- аттрибуты `data-test` (также могут встречаться старые `data-e2e` или сторонние `data-qa`).

В тестовых сценариях селекторы не используются, вместо этого тестовые сценарии работают с абстракцией страниц — страниц статуса стейджа, истории и т.д. Страницы реализуют внутри себя доступ к нужным элементам по селекторам, код извне только вызывает методы у страниц или использует их поля.

Для внешних компонентов — например облачных селекторов, создаётся абстракция над ними, которая скрывает их устройство и даёт высокоуровневые методы. Это единственное место, где можно завязаться на html разметку, так как не у всех компонентов есть data- аттрибуты. Но важно при обновлении компонетов проверить, не поменялась ли верстка в новой версии. Впрочем, если поменялась, тесты упадут.

Технические детали:
- Абстракции страниц и компонентов реализуются в виде классов
- Селекторы могут быть отданы наружу как статические поля класса
- Предпочтительно использовать элементы для выдачи наружу через `cy.get`. Иначе придётся во внешнем коде каждый раз вызывать `cy.get` над селектором, обычно это не требуется, так как селекторы редко используются совместно с другими селекторами вне класса.
- `cy.get` работает только при запуске тестов, поэтому в классе не может быть вызван при инициализации и тем более в статических методах. Поэтому все использования `cy.get` должны быть либо внутри методов, либо внутри геттеров.
- Если вы переиспользуете приватные методы внутри класса, передавайте им в аргументы селекторы, на не cypress элементы, это уберёт необходимость следить, чтобы `cy.get` не был вызван при инициализации.
- Если нужно выбрать несколько элементов из списка, для селекторов используйт дополнительные data- аттрибуты в разметке. Чем меньше завязки на вёрстку, тем лучше.

## testActions

В коде тестов можно заметить методы у `cy`, которые не гуглятся: это кастомные команды, они хранятся в [commands.ts](support/commands.ts) и [testActions.ts](support/testActions.ts).

В testActions хранятся методы, которые ходят к API напрямую, в обход UI. Например, чтобы протестировать некоторые куски UI, нам нужно соблюсти какие-нибудь начальные условия: чтобы был проект или стейдж с нужными настройками. В таких случаях эту предварительную работу (создание стейджа/проекта для теста) делают не с помощью UI, а простым обращением к API.

Чтобы не дублировать код с методами API, его берут со стороны приложения: "цепляют" все методы для работы с апи к объекту `windows`, а на стороне тестов просто пользуются этим объектом. Код работы с апи находится в [ui/src/services/TestActions.ts](../ui/src/services/TestActions.ts), а "зацеп" к `windows` - [ui/src/index.tsx](../ui/src/index.tsx)
