describe('_customCommands', () => {
   before(() => {
      cy.emptyPage();
   });

   context('simple commands', () => {
      it('Should envConfig() works', function() {
         cy.envConfig().then(envConfig => {
            expect(envConfig.clusters).exist;
            expect(envConfig.clusters.length).greaterThan(0);
         });
      });
   });

   context('testActions', () => {
      it('Should testActions() exist', () => {
         cy.testActions().then(actions => {
            expect(actions).exist;

            assert.isFunction(actions.pushUrl);
            assert.isFunction(actions.createStage);
            assert.isFunction(actions.deleteStage);
            assert.isFunction(actions.createProject);
            assert.isFunction(actions.deleteProject);
         });
      });

      it('Should pushUrl() works', () => {
         cy.pushUrl('/changelog');

         cy.location('pathname').should('eql', '/changelog');

         cy.pushUrl('/about');

         cy.location('pathname').should('eql', '/about');
      });
   });
});
