import { TextInputField, YCSelectField, YCSelectMultipleField } from '../page_objects/components';
import { JsonCustom } from '../page_objects/components/JsonCustom';
import { SecretSubForm } from '../page_objects/components/SecretSubForm';
import { dataTest, getStoryRawUrl, getStoryUrl, SECRET, sel } from '../utils';

context('_cypressComponents', () => {
   context('TextInputField', () => {
      const ID = 'TextInputField';

      before(() => {
         cy.visit(getStoryUrl(ID));
      });

      const component = new TextInputField(sel(dataTest(ID), '.textinput'));

      it('Be visible', () => {
         component.getInput().should('be.visible');
      });

      it('Can read value', () => {
         component.getInput().then(input$ => {
            expect(input$.val()).eq('old value');
         });
      });

      it('Can write value (set)', () => {
         component.set('new value');
      });

      it('Can write value (type)', () => {
         component.set('new value2');
      });
   });

   context('YCSelectField', () => {
      const ID = 'YCSelectField';

      before(() => {
         cy.visit(getStoryUrl(ID));
      });

      const component = new YCSelectField(sel(dataTest(ID), '.yc-select-control'), { showSearch: true });

      it('Be visible', () => {
         cy.get(component.switcher).should('be.visible');
      });

      it('Can read value', () => {
         cy.get(component.switcher).should('have.text', 'Option2');
      });

      it('Can write value', () => {
         component.set('Option3');
      });
   });

   context('YCSelectMultipleField', () => {
      const ID = 'YCSelectMultipleField';

      before(() => {
         cy.visit(getStoryUrl(ID));
      });

      const component = new YCSelectMultipleField(sel(dataTest(ID), '.yc-select-control'));

      it('Be visible', () => {
         cy.get(component.switcher).should('be.visible');
      });

      it('Can read value', () => {
         cy.get(component.switcher).should('have.text', 'Option2, Option3');
      });

      // TODO: change/select values
   });

   context('SecretSubForm', () => {
      const ID = 'modules-secrets-secretsubform--regular';

      beforeEach(() => {
         cy.loginRobot();
         cy.visit(getStoryRawUrl(ID));
      });

      const component = new SecretSubForm(sel('label[for="emptySecret"] + div'));

      it('Can add secret', () => {
         component.addNewSecret(SECRET.name);
      });

      it('Can select key', () => {
         component.addNewSecret(SECRET.name);
         component.selectKey(SECRET.keys[0]);
      });
   });

   context('JsonCustom', () => {
      const ID = 'components-common-jsoncustom--object-story';

      before(() => {
         cy.visit(getStoryRawUrl(ID));
      });

      const component = new JsonCustom('');

      const json =
         '{"empty_object":{},"empty_array":[],"empty_string":"","string":"0000-00-00T00:00:00.000000Z","number":0,"true":true,"false":false,"null":null,"undefined":undefined,"array":["abc",123],"object":{"abc":123},"stack_trace":"org.quartz.SchedulerException: Job threw an unhandled exception.\n\tat org.quartz.core.JobRunShell.run(JobRunShell.java:213)\n\tat org.quartz.simpl.SimpleThreadPool$WorkerThread.run(SimpleThreadPool.java:573)\n\tCaused by: org.springframework.jdbc.UncategorizedSQLException: jOOQ; uncategorized SQLException for SQL [update clean_cutoff set timestamp = ? where clean_cutoff.type = ?]; SQL state [25P02]; error code [0]; ERROR: current transaction is aborted, commands ignored until end of transaction block; nested exception is org.postgresql.util.PSQLException: ERROR: current transaction is aborted, commands ignored until end of transaction block\n\tat org.jooq_3.10.7.POSTGRES_9_5.debug(Unknown Source)\n\tat org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:84)\n\tat org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:81)\n\tat org.springframework.jdbc.support.AbstractFallbackSQLExceptionTranslator.translate(AbstractFallbackSQLExceptionTranslator.java:81)\n\tat ru.yandex.qe.hitman.comrade.domain.jooq.spring.ExceptionTranslator.exception(ExceptionTranslator.java:26)\n\tat org.jooq.impl.ExecuteListeners.exception(ExecuteListeners.java:240)\n\tat org.jooq.impl.AbstractQuery.execute(AbstractQuery.java:362)\n\tat org.jooq.impl.AbstractDelegatingQuery.execute(AbstractDelegatingQuery.java:127)\n\tat ru.yandex.qe.hitman.comrade.domain.repository.impl.DbCleanCutoffRepository.putInterval(DbCleanCutoffRepository.java:48)\n\tat ru.yandex.qe.hitman.comrade.domain.repository.clean.DbCleaner$1.doInTransactionWithoutResult(DbCleaner.java:80)\n\tat org.springframework.transaction.support.TransactionCallbackWithoutResult.doInTransaction(TransactionCallbackWithoutResult.java:34)\n\tat org.springframework.transaction.support.TransactionTemplate.execute(TransactionTemplate.java:133)\n\tat ru.yandex.qe.hitman.comrade.domain.repository.clean.DbCleaner.doClean(DbCleaner.java:62)\n\tat ru.yandex.qe.hitman.comrade.application.quartz.DbCleanJob.execute(DbCleanJob.java:30)\n\tat org.quartz.core.JobRunShell.run(JobRunShell.java:202)\n\t\t... 1 common frames omitted\n\tCaused by: org.postgresql.util.PSQLException: ERROR: current transaction is aborted, commands ignored until end of transaction block\n\tat org.postgresql.core.v3.QueryExecutorImpl.receiveErrorResponse(QueryExecutorImpl.java:2270)\n\tat org.postgresql.core.v3.QueryExecutorImpl.processResults(QueryExecutorImpl.java:1998)\n\tat org.postgresql.core.v3.QueryExecutorImpl.execute(QueryExecutorImpl.java:255)\n\tat org.postgresql.jdbc2.AbstractJdbc2Statement.execute(AbstractJdbc2Statement.java:570)\n\tat org.postgresql.jdbc2.AbstractJdbc2Statement.executeWithFlags(AbstractJdbc2Statement.java:420)\n\tat org.postgresql.jdbc2.AbstractJdbc2Statement.execute(AbstractJdbc2Statement.java:413)\n\tat org.apache.commons.dbcp2.DelegatingPreparedStatement.execute(DelegatingPreparedStatement.java:198)\n\tat org.apache.commons.dbcp2.DelegatingPreparedStatement.execute(DelegatingPreparedStatement.java:198)\n\tat org.jooq.tools.jdbc.DefaultPreparedStatement.execute(DefaultPreparedStatement.java:209)\n\tat org.jooq.impl.AbstractQuery.execute(AbstractQuery.java:429)\n\tat org.jooq.impl.AbstractDMLQuery.execute(AbstractDMLQuery.java:452)\n\tat org.jooq.impl.AbstractQuery.execute(AbstractQuery.java:347)\n\t\t... 9 common frames omitted"}';

      it('Should contain valid json', () => {
         cy.get(component.wrapper).find(`div[data-key="undefined"] span.value`).should('have.text', 'undefined');
         cy.get(component.wrapper).find(`div[data-key="null"] span.value`).should('have.text', 'null');
         cy.get(component.wrapper).find(`div[data-key="true"] span.value`).should('have.text', 'true');
         cy.get(component.wrapper).find(`div[data-key="false"] span.value`).should('have.text', 'false');

         // string
         cy.get(component.wrapper).find(`div[data-key="empty_string"] span.value`).should('have.text', '""');
         cy.get(component.wrapper)
            .find(`div[data-key="string"] span.value`)
            .should('have.text', '"0000-00-00T00:00:00.000000Z"');

         // array
         cy.get(component.wrapper).find(`div[data-key="empty_array"]`).should('include.text', '[]');
         cy.get(component.wrapper).find(`div[data-key="array"] div span.value`).first().should('have.text', '"abc"');
         cy.get(component.wrapper).find(`div[data-key="array"] div span.value`).last().should('have.text', '123');

         // object
         cy.get(component.wrapper).find(`div[data-key="empty_object"]`).should('include.text', '{}');
         cy.get(component.wrapper)
            .find(`div[data-key="object"] div[data-key="abc"] span.value`)
            .should('have.text', '123');

         component.check(json);
      });
   });
});
