import { distributeTasksBetweenProcesses } from '../utils/distributeTasksBetweenProcesses';

describe('_utils (unit-tests)', () => {
   describe('distributeTasksBetweenProcesses', () => {
      it('should return empty process list for empty tasks', () => {
         expect(
            distributeTasksBetweenProcesses({
               tasks: [],
               preparationDuration: 10,
               processLimit: 4,
            }),
         ).eql([]);
      });

      it('should distribute simple', () => {
         expect(
            distributeTasksBetweenProcesses({
               preparationDuration: 10,
               processLimit: 4,
               tasks: [
                  { duration: 10, name: 'test1' },
                  { duration: 13, name: 'test4' },
                  { duration: 12, name: 'test3' },
                  { duration: 11, name: 'test2' },
               ],
            }),
         ).eql([
            { duration: 23, tasks: [{ duration: 13, name: 'test4' }] },
            { duration: 22, tasks: [{ duration: 12, name: 'test3' }] },
            { duration: 21, tasks: [{ duration: 11, name: 'test2' }] },
            { duration: 20, tasks: [{ duration: 10, name: 'test1' }] },
         ]);
      });

      it('should add new tasks and skip unused', () => {
         expect(
            distributeTasksBetweenProcesses({
               actualTasks: ['test2', 'test1', 'test100'],
               preparationDuration: 10,
               processLimit: 4,
               tasks: [
                  { duration: 10, name: 'test1' },
                  { duration: 13, name: 'test4' },
                  { duration: 12, name: 'test3' },
                  { duration: 11, name: 'test2' },
               ],
            }),
         ).eql([
            { duration: 21, tasks: [{ duration: 11, name: 'test2' }] },
            { duration: 20.5, tasks: [{ duration: 10.5, name: 'test100' }] },
            { duration: 20, tasks: [{ duration: 10, name: 'test1' }] },
         ]);
      });

      it('should distribute complex case', () => {
         expect(
            distributeTasksBetweenProcesses({
               preparationDuration: 10,
               processLimit: 4,
               tasks: [
                  { duration: 10, name: 'test1' },
                  { duration: 13, name: 'test4' },
                  { duration: 12, name: 'test3' },
                  { duration: 11, name: 'test2' },
                  { duration: 1, name: 'test5' },
                  { duration: 2, name: 'test6' },
                  { duration: 1, name: 'test7' },
                  { duration: 4, name: 'test8' },
                  { duration: 3, name: 'test9' },
                  { duration: 1, name: 'test10' },
                  { duration: 2, name: 'test11' },
                  { duration: 110, name: 'test12' },
               ],
            }),
         ).eql([
            { duration: 120, tasks: [{ duration: 110, name: 'test12' }] },
            {
               duration: 30,
               tasks: [
                  { duration: 13, name: 'test4' },
                  { duration: 3, name: 'test9' },
                  { duration: 2, name: 'test6' },
                  { duration: 1, name: 'test5' },
                  { duration: 1, name: 'test10' },
               ],
            },
            {
               duration: 29,
               tasks: [
                  { duration: 12, name: 'test3' },
                  { duration: 4, name: 'test8' },
                  { duration: 2, name: 'test11' },
                  { duration: 1, name: 'test7' },
               ],
            },
            {
               duration: 31,
               tasks: [
                  { duration: 11, name: 'test2' },
                  { duration: 10, name: 'test1' },
               ],
            },
         ]);
      });
   });
});
