import { StagePage } from '../../../page_objects/stage/StagePage';
import { getStageName, ROUTES, TIMEOUTS } from '../../../utils';

const stageName = getStageName('approval_policy');
const stagePage = new StagePage(stageName);
const { deployTicketsTab } = stagePage;

context('ApprovalPolicy', () => {
   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
      cy.createSimpleStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('should have working approval policy', () => {
      cy.pushUrl(stagePage.pathname);
      cy.wait(TIMEOUTS.waitStageAcl);

      cy.get(stagePage.tabList.get('deployTickets').link).click();

      cy.location('pathname').should('eq', ROUTES.stageDeployTickets(stageName));
      cy.get(deployTicketsTab.body).should('exist');

      cy.get(deployTicketsTab.buttons.approvalPolicy).click();
      const approvalPolicy = deployTicketsTab.approvalPolicy;
      cy.get(approvalPolicy.body).should('exist');

      cy.get(approvalPolicy.actions.init).click();
      cy.get(approvalPolicy.form.body).should('exist');
      approvalPolicy.form.set({
         count: '1',
      });
      cy.get(approvalPolicy.actions.create).click();

      cy.get(approvalPolicy.form.body).should('exist');
      cy.get(deployTicketsTab.approvalPolicy.closeButton).click();
      cy.get(approvalPolicy.body).should('not.exist');

      cy.get(deployTicketsTab.buttons.approvalPolicy).click();
      cy.get(approvalPolicy.body).should('exist');
      approvalPolicy.form.set({
         count: '2',
      });
      cy.get(approvalPolicy.actions.update).click();
      cy.get(approvalPolicy.actions.confirmUpdating).click();
      cy.get(approvalPolicy.form.body).should('exist');

      cy.get(approvalPolicy.actions.delete).click();
      cy.get(approvalPolicy.actions.confirmDeleting).click();

      cy.get(approvalPolicy.form.body).should('not.exist');
   });
});
