import { StagePage } from '../../../page_objects/stage/StagePage';
import { getStageName, ROUTES, SERVICE, SERVICES, TIMEOUTS } from '../../../utils';

const stageName = getStageName('deploy_ticket_creation');
const page = new StagePage(stageName);
const tab = page.deployTicketsTab;

context('DeployTicketCreate', () => {
   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
      cy.createStageWithStatic(stageName);
   });

   beforeEach(() => {
      cy.pushUrl(ROUTES.stage(stageName));
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should create deploy ticket', () => {
      cy.pushUrl(ROUTES.stageDeployTickets(stageName));
      cy.location('pathname').should('eq', tab.pathname);
      cy.get(tab.buttons.approvalPolicy).click();
      cy.get(tab.approvalPolicy.actions.init).click();
      tab.approvalPolicy.form.fields.count.set('1');
      cy.get(tab.approvalPolicy.actions.create).click();
      cy.get(tab.approvalPolicy.closeButton).click();

      cy.get(page.buttons.editLink).click();
      page.editTab.buttons.update.click();
      page.editTab.diffView.descriptionField.set('testcafe create draft');
      cy.get(page.editTab.diffView.buttons.saveAsDraft).click();
      cy.wait(TIMEOUTS.slow); // TODO заменить на условный таймаут

      cy.get(tab.ticket.status).contains('Waiting for approve').should('exist');
      tab.ticket.actions.approve();

      cy.get(tab.ticket.status).contains('Waiting for commit').should('exist');
      tab.ticket.actions.commit();

      cy.get(tab.ticket.status).contains('Committed', { timeout: TIMEOUTS.superSlow }).should('exist');

      cy.get(page.tabLinks.status).click();
      cy.location('pathname').should('eq', page.statusTab.pathname);

      if (SERVICE === SERVICES.BACKEND) {
         page.statusTab.stageReadyAfterSave('2');
      }
   });
});
