import { StagePage } from '../../../page_objects/stage/StagePage';
import { dataTest, getStageName, ROUTES, sel, SERVICE, SERVICES, TIMEOUTS } from '../../../utils';

const stageName = getStageName('release_rule_creation');
const page = new StagePage(stageName);
const tab = page.deployTicketsTab;

const releaseRule = {
   taskType: 'SAMPLE_RELEASE_TO_YA_DEPLOY_2',
   releaseTypes: ['prestable', 'testing'],
   autocommit: true,
   resources: [
      {
         type: 'SAMPLE_RELEASE_INTEGRATION_STATIC',
         target: 'my-static',
         name: 'patch-my-static',
      },
      {
         type: 'SAMPLE_RELEASE_INTEGRATION_LAYER',
         target: 'simple_http_server',
         name: 'patch-my-layer',
      },
   ],
};

context('ReleaseRuleCreate', () => {
   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
      cy.createStageWithStatic(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
      cy.deleteRelease('simple-sandbox-release').log('Delete release');
   });

   it('Should create release rule', () => {
      cy.pushUrl(ROUTES.stageDeployTickets(stageName));
      cy.get(tab.releaseRulePopup.wrapper).click();
      tab.releaseRulePopup.actions.newSandboxRule();

      cy.get(tab.releaseRule.form.buttons.addPatch).click();
      tab.releaseRule.form.set(releaseRule);

      cy.get(tab.releaseRule.buttons.create).click();

      cy.get(page.tabList.get('deployTickets').link, { timeout: TIMEOUTS.superSlow }).should('exist');
      cy.wait(TIMEOUTS.superSlow);
      cy.createRelease(stageName, 'simple-sandbox-release').log('Created release');
      cy.wait(TIMEOUTS.superSlow);

      cy.get(tab.buttons.forceRefresh).click();
      cy.wait(TIMEOUTS.slow);

      cy.get(tab.ticket.status, { timeout: TIMEOUTS.stageReadyAfterSave })
         .contains('Waiting for commit')
         .should('exist');

      cy.get(sel(tab.body, dataTest('DeployTicket:Link'))).click();

      tab.ticket.actions.commit();

      cy.get(page.tabLinks.status).click();
      cy.location('pathname').should('eq', page.statusTab.pathname);

      if (SERVICE === SERVICES.BACKEND) {
         page.statusTab.stageReadyAfterSave('2');
      }
   });
});
