import { ProjectListPage } from '../../../page_objects/home/ProjectListPage';
import { ProjectPage } from '../../../page_objects/project/ProjectPage';
import { dataTest, DEFAULT_ABC_SERVICE, getProjectName, TIMEOUTS } from '../../../utils';

context('ProjectCreate', () => {
   const projectName = getProjectName('project');

   const projectListPage = new ProjectListPage();
   const projectPage = new ProjectPage(projectName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure project isn't exists
      cy.projectExists(projectName).then(exists => {
         projectPage.visit();

         if (exists) {
            cy.log(`Waiting before deletion (${TIMEOUTS.beforeDeleteNewProject / 1000}s)`);
            cy.wait(TIMEOUTS.beforeDeleteNewProject);
            cy.deleteProject(projectName);
         }
      });
   });

   after(() => {
      // sure project isn't exists
      cy.projectExists(projectName).then(exists => {
         projectPage.visit();

         if (exists) {
            cy.log(`Waiting before deletion (${TIMEOUTS.beforeDeleteNewProject / 1000}s)`);
            cy.wait(TIMEOUTS.beforeDeleteNewProject);
            cy.deleteProject(projectName);
         }
      });
   });

   it('Should create, edit, delete project', () => {
      projectPage.visit();
      projectPage.checkNotFound();

      projectListPage.visit();

      /**
       * Create project: cancel button
       */

      cy.log('Create project: cancel button');

      cy.get(projectListPage.createProjectForm.body).should('not.be.visible');
      cy.get(projectListPage.buttons.create).click();
      cy.get(projectListPage.createProjectForm.body).should('be.visible');

      projectListPage.createProjectForm.cancel();

      cy.get(projectListPage.createProjectForm.body).should('not.be.visible');

      /**
       * Create project: submit button
       */

      cy.log('Create project: submit button');

      cy.get(projectListPage.buttons.create).click();
      cy.get(projectListPage.createProjectForm.body).should('be.visible');

      projectListPage.createProjectForm.check({ name: '', accountId: '', tempAccount: false });
      projectListPage.createProjectForm.set({ tempAccount: true });
      projectListPage.createProjectForm.set({ tempAccount: false });
      projectListPage.createProjectForm.set({ name: projectName, accountId: DEFAULT_ABC_SERVICE });

      cy.log(`Waiting before creation (${TIMEOUTS.beforeCreateNewProject / 1000}s) #DEPLOY-5035 #DEPLOY-4337`);
      cy.wait(TIMEOUTS.beforeCreateNewProject);

      projectListPage.createProjectForm.submit();

      cy.log('redirect to project page');
      cy.location('pathname', { timeout: TIMEOUTS.slow }).should('eq', projectPage.pathname);

      // TODO: пока 5 минут ждём роли проекта можно провести это время с пользой:
      // например, потестировать кнопки создания стейджа и/или фильтры на главной странице

      projectPage.waitForProjectACL();

      /**
       * Edit project: cancel button
       */

      cy.log('Edit project: cancel button');

      cy.get(projectPage.editProjectForm.body).should('not.exist');
      cy.get(projectPage.buttons.editButton).click();
      cy.get(projectPage.editProjectForm.body).should('exist').should('be.visible');

      projectPage.editProjectForm.cancel();

      cy.get(projectPage.editProjectForm.body).should('not.exist');

      /**
       * Edit project: submit button
       */

      cy.log('Edit project: submit button');

      cy.get(projectPage.buttons.editButton).click();
      cy.get(projectPage.editProjectForm.body).should('exist');

      projectPage.editProjectForm.check({
         accountId: DEFAULT_ABC_SERVICE,
         tempAccount: false,
         monitoringProject: '',
         tags: [],
      });

      projectPage.editProjectForm.set({ tempAccount: true, tags: ['tag', 'yet-another-tag'] });
      projectPage.editProjectForm.submit();

      cy.get(projectPage.editProjectForm.body).should('not.exist');

      // TODO: перенести в projectPage
      cy.get(dataTest('TagList')).find(dataTest('TagList:Tag')).contains('tag').should('exist');

      cy.get(projectPage.buttons.editButton).click();
      cy.get(projectPage.editProjectForm.body).should('exist');

      projectPage.editProjectForm.check({
         accountId: '',
         tempAccount: true,
         monitoringProject: '',
         tags: ['tag', 'yet-another-tag'],
      });

      projectPage.editProjectForm.cancel();

      cy.get(projectPage.editProjectForm.body).should('not.exist');

      /**
       * Delete project: submit button
       */

      cy.log('Delete project');
      cy.log(`Waiting before deletion (${TIMEOUTS.beforeDeleteNewProject / 1000}s)`);
      cy.wait(TIMEOUTS.beforeDeleteNewProject);

      cy.get(projectPage.buttons.deleteButton).click();
      cy.get(projectPage.deleteWarning.confirmCheckbox).click();
      cy.get(projectPage.deleteWarning.submitButton).click();

      cy.wait(TIMEOUTS.fast);
      cy.locationUrl().should('eq', projectListPage.pathname);

      projectPage.visit();
      projectPage.checkNotFound();
   });
});
