import { ProjectPage } from '../../../page_objects/project/ProjectPage';
import { DEFAULT_PROJECT, TIMEOUTS } from '../../../utils';

// исключения для тестовых стейджей, которые нельзя удалять
// например, в тесткафешных тестах, которые могут прогоняться в это же время
const skipList = ['nodejsgirl-e2e'];

context('ProjectDeployE2eStagesDeletion', () => {
   const projectName = DEFAULT_PROJECT;
   const projectPage = new ProjectPage(projectName);

   before(() => {
      cy.loginRobot();
   });

   // только для отдельынх прогонов, не стоит запускать параллельно с другими тестами
   it.skip(`Should delete all deploy-e2e project stages (exception for: ${skipList.join(', ')})`, () => {
      cy.visit(projectPage.pathname);

      cy.projectStagesExist(projectName).then(exist => {
         if (exist) {
            cy.get(projectPage.stageList, { timeout: TIMEOUTS.slow }).then(() => {
               cy.get(projectPage.stageLinks).then(stageLinks => {
                  Cypress.$.each(stageLinks, (index, value) => {
                     const stageName = value.outerText;

                     if (!skipList.includes(stageName)) {
                        cy.log(`Stage "${stageName}" removing...`);
                        cy.deleteStage(stageName);
                     } else {
                        cy.log(`Stage "${stageName}" removing is skipped...`);
                     }
                  });
               });
            });

            cy.reload();
         } else {
            cy.log(`Project is empty...`);
         }
      });
   });
});
