import { AppLayout } from '../../../page_objects/AppLayout';
import { ProjectListPage } from '../../../page_objects/home/ProjectListPage';
import { NewStagePage } from '../../../page_objects/stage/NewStagePage';
import { DEFAULT_PROJECT, ROUTES, UI_PROJECT_NAME, UI_STAGE_NAMES, UI_STAGE_NAMES_NO_MATCH } from '../../../utils';

context('ProjectListNavigate', () => {
   before(() => {
      cy.loginRobot();
   });

   const projectListPage = new ProjectListPage();

   beforeEach(() => {
      projectListPage.visit();
   });

   it('Should add ?my=yes for root', () => {
      cy.location('search').should('eq', '?my=yes');

      cy.get(projectListPage.bodySelector).should('exist');
      cy.get(projectListPage.selectors.header).should('exist');
      cy.get(projectListPage.selectors.content).should('exist');
   });

   it('should have AppLayout header', () => {
      const header = AppLayout.appHeader;

      // logo
      cy.get(header.logo).should('be.visible').click();

      // tabs
      cy.get(header.navigationTabs.balancers).should('be.visible').click();
      cy.get(header.navigationTabs.yp).should('be.visible').click();
      cy.get(header.navigationTabs.ypQuotas).should('be.visible').click();
      cy.get(header.navigationTabs.projects).should('be.visible').click();

      // links
      cy.get(header.supportLinks.docs).should('be.visible');
      cy.get(header.supportLinks.telegram).should('be.visible');
      cy.get(header.supportLinks.st).should('be.visible');

      // user
      cy.get(header.user).should('be.visible');

      // events
      cy.get(header.events.popup).should('not.exist');
      cy.get(header.events.badge).should('be.visible').click();
      cy.get(header.events.popup).should('exist');
      cy.get(header.events.badge).should('be.visible').click();
      cy.get(header.events.popup).should('not.exist');
   });

   it('should have PageList filter', () => {
      projectListPage.filters.owner.haveValues(['yes', 'no']); // а не ['My', 'All']
      cy.get(projectListPage.project(DEFAULT_PROJECT)).should('exist');

      projectListPage.filters.type.set('Project');
      projectListPage.filters.name.set(DEFAULT_PROJECT);
      cy.get(projectListPage.buttons.search).click();

      cy.get(projectListPage.project(DEFAULT_PROJECT)).should('exist');

      projectListPage.filters.name.set(`aaa-${DEFAULT_PROJECT}`);
      cy.get(projectListPage.buttons.search).click();
      cy.get(projectListPage.notFound).should('exist');
      cy.get(projectListPage.project(DEFAULT_PROJECT)).should('not.exist');

      cy.get(projectListPage.buttons.reset).click();
      cy.get(projectListPage.project(DEFAULT_PROJECT)).should('exist');

      projectListPage.filters.owner.set('no');
      projectListPage.filters.owner.set('yes');

      cy.get(projectListPage.project(UI_PROJECT_NAME)).click();

      for (const stageName of UI_STAGE_NAMES) {
         cy.get(projectListPage.stage(stageName)).should('exist');
      }

      UI_STAGE_NAMES.forEach((name, i) => {
         projectListPage.filters.name.set(name);
         cy.get(projectListPage.buttons.search).click();

         cy.get(projectListPage.stage(name)).should('exist');
         cy.get(projectListPage.stage(UI_STAGE_NAMES_NO_MATCH[i])).should('not.exist');
      });
   });

   it('should launch new stage', () => {
      cy.get(projectListPage.selectors.header).should('exist');
      cy.get(projectListPage.selectors.content).should('exist');

      const newStagePage = new NewStagePage();

      cy.get(projectListPage.project(DEFAULT_PROJECT)).click();
      cy.get(projectListPage.launchNewStage(DEFAULT_PROJECT)).should('exist').click(); // requires at least 1 stage at DEFAULT_PROJECT
      cy.location('search').should(search => expect(search).to.include(DEFAULT_PROJECT));
      cy.get(newStagePage.hugeForm.stageForm.form.wrapper).should('exist');

      cy.get(AppLayout.appHeader.logo).click();
      cy.get(projectListPage.selectors.header).should('exist');

      cy.get(newStagePage.hugeForm.stageForm.form.wrapper).should('not.exist');
      cy.location('search').should(search => expect(ROUTES.home()).to.include(search));
   });
});
