import { DEFAULT_ABC_SERVICE, DEFAULT_PROJECT, getStageName } from '../../../utils';

import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageHistoryPage } from 'page_objects/stage/StageHistoryPage';
import { StageConfigPage } from 'page_objects/stage/StageConfigPage';

context('QuotaProjectAccountId', () => {
   const stageName = getStageName('quota-project-account-id');
   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);
   const deployUnit = stageEditPage.hugeForm.deployUnit('deployUnit');

   const stageHistoryPage = new StageHistoryPage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Stage cpu over quota caption for project account_id: ""', () => {
      cy.createSimpleStage(stageName, { project: DEFAULT_PROJECT, accountId: '' }).then(() => {
         stageConfigPage.visit();
         stageConfigPage.hugeForm.stageForm.form.check({project: DEFAULT_PROJECT, abc: ''}); // #DEPLOY-5640


         stageEditPage.visit();

         stageEditPage.hugeForm.stageForm.form.check({
            id: stageName,
            project: DEFAULT_PROJECT,
         });

         cy.get(deployUnit.treeItem.linkSelector).click();

         cy.get(stageEditPage.quota.abc).contains('a', DEFAULT_ABC_SERVICE);
         cy.get(stageEditPage.quota.buttons.toggle).click();
         cy.get(stageEditPage.quota.overQuota).should('not.exist');

         // 3. Cpu over quota

         deployUnit.form.set({
            cpu: '1234567890', // гарантированно выходим за доступную квоту
         });

         cy.log('Show over quota caption for cpu');
         cy.get(stageEditPage.quota.overQuota).should('exist');

         deployUnit.form.set({
            cpu: '1', // убираем оверквоту
         });

         cy.get(stageEditPage.quota.overQuota).should('not.exist');

         // TODO: можно добавить сценарии
      });
   });
});
