import {
   DEFAULT_ABC_SERVICE,
   DEFAULT_ACCOUNT_ID,
   DEFAULT_PROJECT,
   getStageName,
   STAGE_LOCATIONS,
} from '../../../utils';

import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageHistoryPage } from 'page_objects/stage/StageHistoryPage';
import { StageConfigPage } from 'page_objects/stage/StageConfigPage';

context('QuotaStageAccountId', () => {
   const stageName = getStageName('quota-stage-account-id');
   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);
   const deployUnit = stageEditPage.hugeForm.deployUnit('deployUnit');

   const stageHistoryPage = new StageHistoryPage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Show locations over quota caption for stage account_id: "abc:service:3494"', () => {
      cy.createSimpleStage(stageName, { project: DEFAULT_PROJECT, accountId: DEFAULT_ACCOUNT_ID }).then(() => {
         stageConfigPage.visit();
         stageConfigPage.hugeForm.stageForm.form.check({project: DEFAULT_PROJECT, abc: DEFAULT_ACCOUNT_ID}); // #DEPLOY-5640

         stageEditPage.visit();

         stageEditPage.hugeForm.stageForm.form.check({
            id: stageName,
            project: DEFAULT_PROJECT,
         });

         cy.get(deployUnit.treeItem.linkSelector).click();

         cy.get(stageEditPage.quota.abc).contains('a', DEFAULT_ABC_SERVICE);
         cy.get(stageEditPage.quota.buttons.toggle).click();
         cy.get(stageEditPage.quota.overQuota).should('not.exist');

         // cy.wait(5000)

         // 2. Location over quota

         deployUnit.form.set({
            locations: [
               {
                  id: STAGE_LOCATIONS[0],
                  podCount: 1234567890, // гарантированно выходим за доступную квоту
               },
            ],
         });

         cy.log('Show over quota caption for location: ' + STAGE_LOCATIONS[0]);
         cy.get(stageEditPage.quota.overQuota).should('exist');

         deployUnit.form.set({
            locations: [
               {
                  id: STAGE_LOCATIONS[0],
                  podCount: 0, // убираем оверквоту
               },
            ],
         });

         cy.get(stageEditPage.quota.overQuota).should('not.exist');

         // TODO: можно добавить сценарии
      });
   });
});
