import { DEFAULT_PROJECT, DISABLED_LOCATIONS, getStageName, STAGE_LOCATIONS } from '../../../utils';

import { StageEditPage } from 'page_objects/stage/StageEditPage';
import { StageHistoryPage } from 'page_objects/stage/StageHistoryPage';
import { StageConfigPage } from 'page_objects/stage/StageConfigPage';

context('QuotaTmp', () => {
   const stageName = getStageName('quota-tmp');
   const stageEditPage = new StageEditPage(stageName);
   const stageConfigPage = new StageConfigPage(stageName);
   const deployUnit = stageEditPage.hugeForm.deployUnit('deployUnit');

   const stageHistoryPage = new StageHistoryPage(stageName);

   const disabledLocationName = DISABLED_LOCATIONS[0];
   const disabledLocationTitle = disabledLocationName.toUpperCase();

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Show new location quota caption for tmp account_id: "tmp"', () => {
      cy.createSimpleStage(stageName, { project: DEFAULT_PROJECT, accountId: 'tmp' }).then(() => {
         stageConfigPage.visit();
         stageConfigPage.hugeForm.stageForm.form.check({project: DEFAULT_PROJECT, abc: 'tmp'}); // #DEPLOY-5640


         stageEditPage.visit();

         cy.get(deployUnit.treeItem.linkSelector).click();

         cy.get(stageEditPage.quota.abc).contains('tmp');
         cy.get(stageEditPage.quota.buttons.toggle).click();
         cy.get(stageEditPage.quota.overQuota).should('not.exist');

         STAGE_LOCATIONS.forEach(location => {
            // есть все локации
            cy.get(stageEditPage.quota.location.title).contains(location.toUpperCase()).should('exist');
         });

         // 1. New location quota

         cy.get(stageEditPage.quota.location.title).contains(disabledLocationTitle).should('not.exist');

         deployUnit.form.set({
            locations: [{ id: disabledLocationName, enabled: true, podCount: 1 }],
         });

         cy.log('Show quota caption for new location: ' + disabledLocationName);
         cy.get(stageEditPage.quota.location.title).contains(disabledLocationTitle).should('exist');

         deployUnit.form.set({
            locations: [{ id: disabledLocationName, enabled: false }],
         });

         cy.get(stageEditPage.quota.location.title).contains(disabledLocationTitle).should('not.exist');

         // TODO: можно добавить сценарии
      });
   });
});
