import { SecretList } from '../../../page_objects/components/SecretList';
import { StagePage } from '../../../page_objects/stage/StagePage';
import { alias, ROUTES } from '../../../utils';

context('secrets/Migration', () => {
   const stageName = 'khoden-secrets'; // getStageName('secrets_migration');
   const page = new StagePage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      // cy.deleteStage(stageName);
      // cy.createSimpleStage(stageName);
   });

   beforeEach(() => {
      cy.pushUrl(ROUTES.stageEdit(stageName));
   });

   after(() => {
      // cy.deleteStage(stageName);
   });

   // сломано
   it.skip('should open secrets tab', () => {
      const deployUnit = page.editTab.hugeForm.deployUnit('du_manual_secrets');

      cy.get(deployUnit.treeItem.linkSelector).click();
      cy.get(deployUnit.formTabs.getTab('Secrets')).click();

      const secretList = new SecretList();

      const versionRow = 'versionRow';
      cy.get(secretList.versionLinks)
         .eq(0) // first version
         .parents('tr')
         .as(versionRow) // alias
         .find(secretList.legacyBadge)
         .should('exist');

      const migrateButton = 'migrateButton';
      cy.get(alias(versionRow))
         .find(secretList.migrateButton)
         .as(migrateButton) // alias
         .should('exist')
         .click()
         .should('not.exist');

      cy.get(alias(versionRow)).find(secretList.undoMigrationButton).should('exist').click().should('not.exist');

      cy.get(alias(migrateButton)).should('exist');
   });
});
