import { NewStagePage } from '../../../page_objects/stage/NewStagePage';
import { StagePage } from '../../../page_objects/stage/StagePage';
import { DEFAULT_ACCOUNT_ID, DEFAULT_PROJECT, getStageName, ROUTES, TIMEOUTS } from '../../../utils';

context('StageCreate', () => {
   const stageName = getStageName('creation');
   const newStagePage = new NewStagePage();
   const stagePage = new StagePage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should create stage', () => {
      /**
       * создание стейджа без проекта (просто проверяем значения полей проекта)
       * TODO: можно добавить переход по кнопке со страницы несуществующего стейджа с проверкой урла
       */

      cy.visit(ROUTES.newStage());

      newStagePage.hugeForm.stageForm.form.check({ project: '' });
      newStagePage.buttons.update.click();
      cy.get(newStagePage.validationModal.okButton).click();
      newStagePage.diffView.checkNotInsertedField('project_id');
      newStagePage.diffView.checkNotInsertedField('account_id'); // #DEPLOY-5640
      newStagePage.diffView.close();

      /**
       * создание стейджа с проектом (проверяем поля проекта и создаём стейдж)
       * TODO: можно добавить переход по кнопке со страницы проекта с проверкой урла
       */

      cy.visit(ROUTES.newStage(DEFAULT_PROJECT));

      newStagePage.hugeForm.stageForm.form.set({ id: stageName });
      newStagePage.hugeForm.stageForm.form.check({ id: stageName, project: DEFAULT_PROJECT });

      newStagePage.fillSimpleStage();

      newStagePage.showDiff();
      newStagePage.diffView.checkInsertedFieldValue('project_id', DEFAULT_PROJECT);
      newStagePage.diffView.checkInsertedFieldValue('account_id', DEFAULT_ACCOUNT_ID); // #DEPLOY-5640
      newStagePage.diffView.deploy('created from UI');

      // redirect to status after creation
      cy.location('pathname').should('eq', stagePage.pathname);

      cy.get(stagePage.statusTab.name, { timeout: TIMEOUTS.slow }).should('have.text', stageName);

      cy.get(stagePage.tabLinks.config).click();
      cy.get(stagePage.tabLinks.logs).click();
      cy.get(stagePage.tabLinks.monitoring).click();
      cy.get(stagePage.tabLinks.history).click();
      cy.get(stagePage.tabLinks.deployTickets).click();
      cy.get(stagePage.tabLinks.balancers).click();
      cy.get(stagePage.tabLinks.status).click();
   });
});
