import { DEFAULT_PROJECT, getStageName, ROUTES, TIMEOUTS } from '../../../utils';

import { DeleteStageModal } from '../../../page_objects/components/DeleteStageModal';
import { StageStatusPage } from '../../../page_objects/stage/StageStatusPage';

context('StageDelete', () => {
   const stageName = getStageName('deletion');

   const stageStatusPage = new StageStatusPage(stageName);
   const deleteStageModal = new DeleteStageModal();

   before(() => {
      cy.loginRobot();
      cy.emptyPage();
   });

   it('Should delete stage', () => {
      cy.createSimpleStage(stageName).then(() => {
         stageStatusPage.visit();

         // close button (in header)
         cy.get(stageStatusPage.buttons.stageActionsPopup).scrollIntoView().click();
         cy.get(stageStatusPage.buttons.deleteButton).scrollIntoView().click();
         cy.get(deleteStageModal.wrapper).should('be.visible');
         cy.get(deleteStageModal.closeButton).click();
         cy.get(deleteStageModal.wrapper).should('not.exist');

         // cancel button (in footer)
         // поломан stageActionsPopup #DEPLOY-5045
         // cy.get(existPage.buttons.stageActionsPopup).click();
         cy.get(stageStatusPage.buttons.deleteButton).scrollIntoView().click();
         cy.get(deleteStageModal.wrapper).should('be.visible');
         cy.get(deleteStageModal.cancelButton).click();
         cy.get(deleteStageModal.wrapper).should('not.exist');

         // ok button
         // поломан stageActionsPopup #DEPLOY-5045
         // cy.get(existPage.buttons.stageActionsPopup).click();
         cy.get(stageStatusPage.buttons.deleteButton).scrollIntoView().click();
         cy.get(deleteStageModal.wrapper).should('be.visible');

         // Ждём, когда пропадет индикатор загрузки (Проверка AWACS)
         cy.get(deleteStageModal.loader, { timeout: TIMEOUTS.slow }).should('not.exist');

         cy.get(deleteStageModal.checkbox).should('exist').should('not.be.checked');

         cy.get(deleteStageModal.checkbox)
            .should('not.be.disabled', { timeout: TIMEOUTS.waitStageDeletionCheckbox })
            .click()
            .should('be.checked');

         cy.get(deleteStageModal.okButton).click();
         cy.get(deleteStageModal.wrapper, { timeout: TIMEOUTS.superSlow }).should('not.exist');

         // should redirect to project
         cy.location('pathname').should('eq', ROUTES.project(DEFAULT_PROJECT));
      });
   });
});
