import { StagePage } from '../../../page_objects/stage/StagePage';
import { getStageName, ROUTES } from '../../../utils';

context('StageNavigateOverTabs', () => {
   const stageName = getStageName('stage_layout');
   const page = new StagePage(stageName);

   before(() => {
      cy.loginRobot();
      cy.emptyPage();

      // sure stage isn't exists
      cy.deleteStage(stageName);
      cy.createSimpleStage(stageName);
   });

   beforeEach(() => {
      cy.pushUrl(ROUTES.stage(stageName));
   });

   after(() => {
      cy.deleteStage(stageName);
   });

   it('Should open status tab by default', () => {
      cy.location('pathname').should('eq', page.statusTab.pathname);
   });

   it('Should open each stage tab', () => {
      for (const { link, page: tabPage } of Array.from(page.tabList.values())) {
         cy.get(link).click();
         cy.location('pathname').should('eq', tabPage.pathname);
         cy.get(tabPage.body).should('exist');
      }
   });

   it('Should open stage for editing', () => {
      cy.get(page.buttons.editLink).click();
      cy.location('pathname').should('eq', page.editTab.pathname);

      // TODO test canceling
   });
});
